/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.tez.runtime.api.impl.TaskSpec;

public class AMContainerTask {
    private final Map<String, LocalResource> additionalResources;
    private final TaskSpec tezTask;
    private final Credentials credentials;
    private final boolean credentialsChanged;
    private final int priority;

    public AMContainerTask(TaskSpec tezTask, Map<String, LocalResource> additionalResources, Credentials credentials, boolean credentialsChanged, int priority) {
        Objects.requireNonNull(tezTask, "TaskSpec cannot be null");
        this.tezTask = tezTask;
        this.additionalResources = additionalResources;
        this.credentials = credentials;
        this.credentialsChanged = credentialsChanged;
        this.priority = priority;
    }

    public TaskSpec getTask() {
        return this.tezTask;
    }

    public Map<String, LocalResource> getAdditionalResources() {
        return this.additionalResources;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public boolean haveCredentialsChanged() {
        return this.credentialsChanged;
    }

    public int getPriority() {
        return this.priority;
    }
}

