/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.speculation.legacy;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.speculation.legacy.StartEndTimesBase;
import org.apache.tez.dag.app.dag.speculation.legacy.forecast.SimpleExponentialSmoothing;
import org.apache.tez.dag.records.TezTaskAttemptID;

public class SimpleExponentialTaskRuntimeEstimator
extends StartEndTimesBase {
    private static final long DEFAULT_ESTIMATE_RUNTIME = -1L;
    private static final double DEFAULT_PROGRESS_VALUE = 1.0E-10;
    private static final double CONFIDENCE_INTERVAL_FACTOR = 0.25;
    private long constTime;
    private int skipCount;
    private long stagnatedWindow;
    private final ConcurrentMap<TezTaskAttemptID, AtomicReference<SimpleExponentialSmoothing>> estimates = new ConcurrentHashMap<TezTaskAttemptID, AtomicReference<SimpleExponentialSmoothing>>();

    private SimpleExponentialSmoothing getForecastEntry(TezTaskAttemptID attemptID) {
        AtomicReference entryRef = (AtomicReference)this.estimates.get(attemptID);
        if (entryRef == null) {
            return null;
        }
        return (SimpleExponentialSmoothing)entryRef.get();
    }

    private void incorporateReading(TezTaskAttemptID attemptID, float newRawData, long newTimeStamp) {
        SimpleExponentialSmoothing foreCastEntry = this.getForecastEntry(attemptID);
        if (foreCastEntry == null) {
            Long tStartTime = (Long)this.startTimes.get(attemptID);
            if (tStartTime == null) {
                return;
            }
            this.estimates.putIfAbsent(attemptID, new AtomicReference<SimpleExponentialSmoothing>(SimpleExponentialSmoothing.createForecast(this.constTime, this.skipCount, this.stagnatedWindow, tStartTime - 1L)));
            this.incorporateReading(attemptID, newRawData, newTimeStamp);
            return;
        }
        foreCastEntry.incorporateReading(newTimeStamp, newRawData);
    }

    @Override
    public void contextualize(Configuration conf, Vertex vertex) {
        super.contextualize(conf, vertex);
        this.constTime = conf.getLong("tez.am.task.estimator.exponential.lambda.ms", TezConfiguration.TEZ_AM_ESTIMATOR_EXPONENTIAL_LAMBDA_MS_DEFAULT);
        this.stagnatedWindow = Math.max(2L * this.constTime, conf.getLong("tez.am.task.estimator.exponential.stagnated.ms", TezConfiguration.TEZ_AM_ESTIMATOR_EXPONENTIAL_STAGNATED_MS_DEFAULT));
        this.skipCount = conf.getInt("tez.am.task.estimator.exponential.skip.initials", 24);
    }

    @Override
    public long estimatedRuntime(TezTaskAttemptID id) {
        SimpleExponentialSmoothing foreCastEntry = this.getForecastEntry(id);
        if (foreCastEntry == null) {
            return -1L;
        }
        double remainingWork = Math.max(0.0, Math.min(1.0, 1.0 - foreCastEntry.getRawData()));
        double forecast = Math.max(1.0E-10, foreCastEntry.getForecast());
        long remainingTime = (long)(remainingWork / forecast);
        long estimatedRuntime = remainingTime + foreCastEntry.getTimeStamp() - foreCastEntry.getStartTime();
        return estimatedRuntime;
    }

    @Override
    public long newAttemptEstimatedRuntime() {
        if (this.taskStatistics == null) {
            return -1L;
        }
        double statsMeanCI = this.taskStatistics.meanCI();
        double expectedVal = statsMeanCI + Math.min(statsMeanCI * 0.25, this.taskStatistics.std() / 2.0);
        return (long)expectedVal;
    }

    @Override
    public boolean hasStagnatedProgress(TezTaskAttemptID id, long timeStamp) {
        SimpleExponentialSmoothing foreCastEntry = this.getForecastEntry(id);
        if (foreCastEntry == null) {
            return false;
        }
        return foreCastEntry.isDataStagnated(timeStamp);
    }

    @Override
    public long runtimeEstimateVariance(TezTaskAttemptID id) {
        SimpleExponentialSmoothing forecastEntry = this.getForecastEntry(id);
        if (forecastEntry == null) {
            return -1L;
        }
        double forecast = forecastEntry.getForecast();
        if (forecastEntry.isDefaultForecast(forecast)) {
            return -1L;
        }
        return 0L;
    }

    @Override
    public void updateAttempt(TezTaskAttemptID attemptID, TaskAttemptState state, long timestamp) {
        super.updateAttempt(attemptID, state, timestamp);
        Task task = this.vertex.getTask(attemptID.getTaskID());
        if (task == null) {
            return;
        }
        TaskAttempt taskAttempt = task.getAttempt(attemptID);
        if (taskAttempt == null) {
            return;
        }
        float progress = taskAttempt.getProgress();
        this.incorporateReading(attemptID, progress, timestamp);
    }
}

