/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.HeartbeatHandlerBase;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventAttemptFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.TaskFailureType;

public class TaskHeartbeatHandler
extends HeartbeatHandlerBase<TezTaskAttemptID> {
    public TaskHeartbeatHandler(AppContext context, int expectedConcurrency) {
        super(context, expectedConcurrency, "TaskHeartbeatHandler");
    }

    @Override
    protected int getConfiguredTimeout(Configuration conf) {
        return conf.getInt("tez.task.timeout-ms", 300000);
    }

    @Override
    protected int getConfiguredTimeoutCheckInterval(Configuration conf) {
        return conf.getInt("tez.task.heartbeat.timeout.check-ms", 30000);
    }

    @Override
    protected boolean hasTimedOut(HeartbeatHandlerBase.ReportTime report, long currentTime) {
        return this.timeOut > 0 && currentTime > report.getLastPing() + (long)this.timeOut;
    }

    @Override
    protected void handleTimeOut(TezTaskAttemptID attemptId) {
        this.eventHandler.handle((Event)new TaskAttemptEventAttemptFailed(attemptId, TaskAttemptEventType.TA_TIMED_OUT, TaskFailureType.NON_FATAL, "AttemptID:" + attemptId.toString() + " Timed out after " + this.timeOut / 1000 + " secs", TaskAttemptTerminationCause.TASK_HEARTBEAT_ERROR));
    }
}

