/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.examples;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.client.TezClient;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.examples.HashJoinExample;
import org.apache.tez.examples.TezExampleBase;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.Reader;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVEdgeConfig;
import org.apache.tez.runtime.library.partitioner.HashPartitioner;
import org.apache.tez.runtime.library.processor.SimpleProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinValidate
extends TezExampleBase {
    private static final Logger LOG = LoggerFactory.getLogger(JoinValidate.class);
    private static final String LHS_INPUT_NAME = "lhsfile";
    private static final String RHS_INPUT_NAME = "rhsfile";
    private static final String COUNTER_GROUP_NAME = "JOIN_VALIDATE";
    private static final String MISSING_KEY_COUNTER_NAME = "MISSING_KEY_EXISTS";

    public static void main(String[] args) throws Exception {
        JoinValidate validate = new JoinValidate();
        int status = ToolRunner.run((Configuration)new Configuration(), (Tool)validate, (String[])args);
        System.exit(status);
    }

    @Override
    protected void printUsage() {
        System.err.println("Usage: joinvalidate <path1> <path2>");
    }

    @Override
    protected int runJob(String[] args, TezConfiguration tezConf, TezClient tezClient) throws Exception {
        DAGStatus dagStatus;
        LOG.info("Running JoinValidate");
        String lhsDir = args[0];
        String rhsDir = args[1];
        int numPartitions = 1;
        if (args.length == 3) {
            numPartitions = Integer.parseInt(args[2]);
        }
        if (numPartitions <= 0) {
            System.err.println("NumPartitions must be > 0");
            return 4;
        }
        Path lhsPath = new Path(lhsDir);
        Path rhsPath = new Path(rhsDir);
        DAG dag = this.createDag(tezConf, lhsPath, rhsPath, numPartitions);
        tezClient.waitTillReady();
        DAGClient dagClient = tezClient.submitDAG(dag);
        HashSet getOpts = Sets.newHashSet();
        if (this.isCountersLog()) {
            getOpts.add(StatusGetOpts.GET_COUNTERS);
        }
        if ((dagStatus = dagClient.waitForCompletionWithStatusUpdates((Set)getOpts)).getState() != DAGStatus.State.SUCCEEDED) {
            LOG.info("DAG diagnostics: " + dagStatus.getDiagnostics());
            return -1;
        }
        dagStatus = dagClient.getDAGStatus((Set)Sets.newHashSet((Object[])new StatusGetOpts[]{StatusGetOpts.GET_COUNTERS}));
        TezCounter counter = dagStatus.getDAGCounters().findCounter(COUNTER_GROUP_NAME, MISSING_KEY_COUNTER_NAME);
        if (counter == null) {
            LOG.info("Unable to determing equality");
            return -2;
        }
        if (counter.getValue() != 0L) {
            LOG.info("Validate failed. The two sides are not equivalent");
            return -3;
        }
        LOG.info("Validation successful. The two sides are equivalent");
        return 0;
    }

    @Override
    protected int validateArgs(String[] otherArgs) {
        if (otherArgs.length != 3 && otherArgs.length != 2) {
            return 2;
        }
        return 0;
    }

    @VisibleForTesting
    DAG createDag(TezConfiguration tezConf, Path lhs, Path rhs, int numPartitions) throws IOException {
        DAG dag = DAG.create((String)this.getDagName());
        if (this.getDefaultExecutionContext() != null) {
            dag.setExecutionContext(this.getDefaultExecutionContext());
        }
        OrderedPartitionedKVEdgeConfig edgeConf = OrderedPartitionedKVEdgeConfig.newBuilder((String)Text.class.getName(), (String)NullWritable.class.getName(), (String)HashPartitioner.class.getName()).setFromConfiguration((Configuration)tezConf).build();
        Vertex lhsVertex = Vertex.create((String)LHS_INPUT_NAME, (ProcessorDescriptor)ProcessorDescriptor.create((String)HashJoinExample.ForwardingProcessor.class.getName())).addDataSource("lhs", MRInput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextInputFormat.class, (String)lhs.toUri().toString()).groupSplits(!this.isDisableSplitGrouping()).generateSplitsInAM(!this.isGenerateSplitInClient()).build());
        this.setVertexExecutionContext(lhsVertex, this.getLhsExecutionContext());
        Vertex rhsVertex = Vertex.create((String)RHS_INPUT_NAME, (ProcessorDescriptor)ProcessorDescriptor.create((String)HashJoinExample.ForwardingProcessor.class.getName())).addDataSource("rhs", MRInput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextInputFormat.class, (String)rhs.toUri().toString()).groupSplits(!this.isDisableSplitGrouping()).generateSplitsInAM(!this.isGenerateSplitInClient()).build());
        this.setVertexExecutionContext(rhsVertex, this.getRhsExecutionContext());
        Vertex joinValidateVertex = Vertex.create((String)"joinvalidate", (ProcessorDescriptor)ProcessorDescriptor.create((String)JoinValidateProcessor.class.getName()), (int)numPartitions);
        this.setVertexExecutionContext(joinValidateVertex, this.getValidateExecutionContext());
        Edge e1 = Edge.create((Vertex)lhsVertex, (Vertex)joinValidateVertex, (EdgeProperty)edgeConf.createDefaultEdgeProperty());
        Edge e2 = Edge.create((Vertex)rhsVertex, (Vertex)joinValidateVertex, (EdgeProperty)edgeConf.createDefaultEdgeProperty());
        dag.addVertex(lhsVertex).addVertex(rhsVertex).addVertex(joinValidateVertex).addEdge(e1).addEdge(e2);
        return dag;
    }

    private void setVertexExecutionContext(Vertex vertex, Vertex.VertexExecutionContext executionContext) {
        if (executionContext != null) {
            vertex.setExecutionContext(executionContext);
        }
    }

    protected Vertex.VertexExecutionContext getDefaultExecutionContext() {
        return null;
    }

    protected Vertex.VertexExecutionContext getLhsExecutionContext() {
        return null;
    }

    protected Vertex.VertexExecutionContext getRhsExecutionContext() {
        return null;
    }

    protected Vertex.VertexExecutionContext getValidateExecutionContext() {
        return null;
    }

    protected String getDagName() {
        return "JoinValidate";
    }

    public static class JoinValidateProcessor
    extends SimpleProcessor {
        private static final Logger LOG = LoggerFactory.getLogger(JoinValidateProcessor.class);

        public JoinValidateProcessor(ProcessorContext context) {
            super(context);
        }

        public void run() throws Exception {
            Preconditions.checkState((this.getInputs().size() == 2 ? 1 : 0) != 0);
            Preconditions.checkState((this.getOutputs().size() == 0 ? 1 : 0) != 0);
            LogicalInput lhsInput = (LogicalInput)this.getInputs().get(JoinValidate.LHS_INPUT_NAME);
            LogicalInput rhsInput = (LogicalInput)this.getInputs().get(JoinValidate.RHS_INPUT_NAME);
            Reader lhsReaderRaw = lhsInput.getReader();
            Reader rhsReaderRaw = rhsInput.getReader();
            Preconditions.checkState((boolean)(lhsReaderRaw instanceof KeyValuesReader));
            Preconditions.checkState((boolean)(rhsReaderRaw instanceof KeyValuesReader));
            KeyValuesReader lhsReader = (KeyValuesReader)lhsReaderRaw;
            KeyValuesReader rhsReader = (KeyValuesReader)rhsReaderRaw;
            boolean rhsReaderEnd = false;
            TezCounter lhsMissingKeyCounter = this.getContext().getCounters().findCounter(JoinValidate.COUNTER_GROUP_NAME, JoinValidate.MISSING_KEY_COUNTER_NAME);
            while (lhsReader.next()) {
                if (rhsReader.next()) {
                    if (lhsReader.getCurrentKey().equals(rhsReader.getCurrentKey())) continue;
                    LOG.info("MismatchedKeys: lhs=" + lhsReader.getCurrentKey() + ", rhs=" + rhsReader.getCurrentKey());
                    lhsMissingKeyCounter.increment(1L);
                    continue;
                }
                lhsMissingKeyCounter.increment(1L);
                LOG.info("ExtraKey in lhs: " + lhsReader.getClass());
                rhsReaderEnd = true;
                break;
            }
            if (!rhsReaderEnd && rhsReader.next()) {
                lhsMissingKeyCounter.increment(1L);
                LOG.info("ExtraKey in rhs: " + rhsReader.getClass());
            }
        }
    }
}

