/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.bridge.scala.internal;

import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.bridge.internal.AbstractStreamTableEnvironmentImpl;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.factories.PlannerFactoryUtil;
import org.apache.flink.table.module.ModuleManager;

public final class StreamTableEnvironmentImpl$ {
    public static StreamTableEnvironmentImpl$ MODULE$;

    static {
        new StreamTableEnvironmentImpl$();
    }

    public StreamTableEnvironmentImpl create(StreamExecutionEnvironment executionEnvironment, EnvironmentSettings settings) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Executor executor = AbstractStreamTableEnvironmentImpl.lookupExecutor((ClassLoader)classLoader, (org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)executionEnvironment.getWrappedStreamExecutionEnvironment());
        TableConfig tableConfig = TableConfig.getDefault();
        tableConfig.setRootConfiguration(executor.getConfiguration());
        tableConfig.addConfiguration(settings.getConfiguration());
        ModuleManager moduleManager = new ModuleManager();
        CatalogManager catalogManager = CatalogManager.newBuilder().classLoader(classLoader).config((ReadableConfig)tableConfig).defaultCatalog(settings.getBuiltInCatalogName(), (Catalog)new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName())).executionConfig(executionEnvironment.getConfig()).build();
        FunctionCatalog functionCatalog = new FunctionCatalog((ReadableConfig)tableConfig, catalogManager, moduleManager);
        Planner planner = PlannerFactoryUtil.createPlanner((Executor)executor, (TableConfig)tableConfig, (ModuleManager)moduleManager, (CatalogManager)catalogManager, (FunctionCatalog)functionCatalog);
        return new StreamTableEnvironmentImpl(catalogManager, moduleManager, functionCatalog, tableConfig, executionEnvironment, planner, executor, settings.isStreamingMode(), classLoader);
    }

    private StreamTableEnvironmentImpl$() {
        MODULE$ = this;
    }
}

