/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Optional;
import java.util.function.Consumer;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingRunnable;

public class OptionalConsumer<T> {
    private final Optional<T> optional;

    private OptionalConsumer(Optional<T> optional) {
        this.optional = Preconditions.checkNotNull(optional);
    }

    public static <T> OptionalConsumer<T> of(Optional<T> optional) {
        return new OptionalConsumer<T>(optional);
    }

    public OptionalConsumer<T> ifPresent(Consumer<T> c) {
        this.optional.ifPresent(c);
        return this;
    }

    public <E extends Exception> OptionalConsumer<T> ifNotPresent(ThrowingRunnable<E> r) throws E {
        if (!this.optional.isPresent()) {
            r.run();
        }
        return this;
    }
}

