/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.system.entity.Team;
import org.apache.streampark.console.system.service.TeamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"team"})
public class TeamController {
    private static final Logger log = LoggerFactory.getLogger(TeamController.class);
    @Autowired
    private TeamService teamService;

    @PostMapping(value={"list"})
    public RestResponse teamList(RestRequest restRequest, Team team) {
        IPage<Team> teamList = this.teamService.page(team, restRequest);
        return RestResponse.success(teamList);
    }

    @PostMapping(value={"check/name"})
    public RestResponse checkTeamName(@NotBlank(message="{required}") @NotBlank(message="{required}") String teamName) {
        Team result = this.teamService.findByName(teamName);
        return RestResponse.success(result == null);
    }

    @PostMapping(value={"post"})
    @RequiresPermissions(value={"team:add"})
    public RestResponse addTeam(@Valid Team team) {
        this.teamService.createTeam(team);
        return RestResponse.success();
    }

    @DeleteMapping(value={"delete"})
    @RequiresPermissions(value={"team:delete"})
    public RestResponse deleteTeam(Team team) {
        this.teamService.deleteTeam(team.getId());
        return RestResponse.success();
    }

    @PutMapping(value={"update"})
    @RequiresPermissions(value={"team:update"})
    public RestResponse updateTeam(Team team) {
        this.teamService.updateTeam(team);
        return RestResponse.success();
    }
}

