/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.wrapper;

import com.p6spy.engine.wrapper.P6Proxy;
import java.sql.SQLException;
import java.sql.Wrapper;

public abstract class AbstractWrapper
implements Wrapper,
P6Proxy {
    private final Object delegate;

    protected AbstractWrapper(Object delegate) {
        this.delegate = delegate;
    }

    public static boolean isProxy(Object obj) {
        return obj != null && AbstractWrapper.isProxy(obj.getClass());
    }

    public static boolean isProxy(Class<?> clazz) {
        return clazz != null && P6Proxy.class.isAssignableFrom(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Object result;
        if (iface.isAssignableFrom(this.getClass())) {
            result = this;
        } else if (iface.isAssignableFrom(this.delegate.getClass())) {
            result = this.unwrapP6SpyProxy();
        } else if (Wrapper.class.isAssignableFrom(this.delegate.getClass())) {
            result = ((Wrapper)this.unwrapP6SpyProxy()).unwrap(iface);
        } else {
            throw new SQLException("Can not unwrap to " + iface.getName());
        }
        return iface.cast(result);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return true;
        }
        if (iface.isAssignableFrom(this.delegate.getClass())) {
            return true;
        }
        if (Wrapper.class.isAssignableFrom(this.delegate.getClass())) {
            return ((Wrapper)this.unwrapP6SpyProxy()).isWrapperFor(iface);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof P6Proxy) {
            obj = ((P6Proxy)obj).unwrapP6SpyProxy();
        }
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Object unwrapP6SpyProxy() {
        return this.delegate;
    }
}

