/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.router;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.rest.handler.router.PathPattern;
import org.apache.flink.runtime.rest.handler.router.RouteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MethodlessRouter<T> {
    private static final Logger log = LoggerFactory.getLogger(MethodlessRouter.class);
    private final Map<PathPattern, T> routes = new LinkedHashMap<PathPattern, T>();

    MethodlessRouter() {
    }

    public Map<PathPattern, T> routes() {
        return Collections.unmodifiableMap(this.routes);
    }

    public MethodlessRouter<T> addRoute(String pathPattern, T target) {
        PathPattern p = new PathPattern(pathPattern);
        if (this.routes.containsKey(p)) {
            return this;
        }
        this.routes.put(p, target);
        return this;
    }

    public void removePathPattern(String pathPattern) {
        PathPattern p = new PathPattern(pathPattern);
        T target = this.routes.remove(p);
        if (target == null) {
            return;
        }
    }

    public RouteResult<T> route(String uri, String decodedPath, Map<String, List<String>> queryParameters, String[] pathTokens) {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        for (Map.Entry<PathPattern, T> entry : this.routes.entrySet()) {
            PathPattern pattern = entry.getKey();
            if (pattern.match(pathTokens, pathParams)) {
                T target = entry.getValue();
                return new RouteResult<T>(uri, decodedPath, pathParams, queryParameters, target);
            }
            pathParams.clear();
        }
        return null;
    }

    public boolean anyMatched(String[] requestPathTokens) {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        for (PathPattern pattern : this.routes.keySet()) {
            if (pattern.match(requestPathTokens, pathParams)) {
                return true;
            }
            pathParams.clear();
        }
        return false;
    }

    public int size() {
        return this.routes.size();
    }
}

