/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.dispatcher.HistoryServerArchivist;
import org.apache.flink.runtime.history.FsJobArchivist;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingRunnable;

class JsonResponseHistoryServerArchivist
implements HistoryServerArchivist {
    private final JsonArchivist jsonArchivist;
    private final Path archivePath;
    private final Executor ioExecutor;

    JsonResponseHistoryServerArchivist(JsonArchivist jsonArchivist, Path archivePath, Executor ioExecutor) {
        this.jsonArchivist = (JsonArchivist)Preconditions.checkNotNull((Object)jsonArchivist);
        this.archivePath = (Path)Preconditions.checkNotNull((Object)archivePath);
        this.ioExecutor = (Executor)Preconditions.checkNotNull((Object)ioExecutor);
    }

    @Override
    public CompletableFuture<Acknowledge> archiveExecutionGraph(ExecutionGraphInfo executionGraphInfo) {
        return CompletableFuture.runAsync(ThrowingRunnable.unchecked(() -> FsJobArchivist.archiveJob(this.archivePath, executionGraphInfo.getJobId(), this.jsonArchivist.archiveJsonWithPath(executionGraphInfo))), this.ioExecutor).thenApply(ignored -> Acknowledge.get());
    }
}

