/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.plantranslate;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.flink.api.common.operators.CompilerHints;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;

public class JsonMapper {
    public static String getOperatorStrategyString(DriverStrategy strategy) {
        return JsonMapper.getOperatorStrategyString(strategy, "input 1", "input 2");
    }

    public static String getOperatorStrategyString(DriverStrategy strategy, String firstInputName, String secondInputName) {
        if (strategy == null) {
            return "(null)";
        }
        switch (strategy) {
            case SOURCE: {
                return "Data Source";
            }
            case SINK: {
                return "Data Sink";
            }
            case NONE: {
                return "(none)";
            }
            case BINARY_NO_OP: 
            case UNARY_NO_OP: {
                return "No-Op";
            }
            case MAP: {
                return "Map";
            }
            case FLAT_MAP: {
                return "FlatMap";
            }
            case MAP_PARTITION: {
                return "Map Partition";
            }
            case ALL_REDUCE: {
                return "Reduce All";
            }
            case ALL_GROUP_REDUCE: 
            case ALL_GROUP_REDUCE_COMBINE: {
                return "Group Reduce All";
            }
            case SORTED_REDUCE: {
                return "Sorted Reduce";
            }
            case SORTED_PARTIAL_REDUCE: {
                return "Sorted Combine/Reduce";
            }
            case SORTED_GROUP_REDUCE: {
                return "Sorted Group Reduce";
            }
            case SORTED_GROUP_COMBINE: {
                return "Sorted Combine";
            }
            case HYBRIDHASH_BUILD_FIRST: {
                return "Hybrid Hash (build: " + firstInputName + ")";
            }
            case HYBRIDHASH_BUILD_SECOND: {
                return "Hybrid Hash (build: " + secondInputName + ")";
            }
            case HYBRIDHASH_BUILD_FIRST_CACHED: {
                return "Hybrid Hash (CACHED) (build: " + firstInputName + ")";
            }
            case HYBRIDHASH_BUILD_SECOND_CACHED: {
                return "Hybrid Hash (CACHED) (build: " + secondInputName + ")";
            }
            case NESTEDLOOP_BLOCKED_OUTER_FIRST: {
                return "Nested Loops (Blocked Outer: " + firstInputName + ")";
            }
            case NESTEDLOOP_BLOCKED_OUTER_SECOND: {
                return "Nested Loops (Blocked Outer: " + secondInputName + ")";
            }
            case NESTEDLOOP_STREAMED_OUTER_FIRST: {
                return "Nested Loops (Streamed Outer: " + firstInputName + ")";
            }
            case NESTEDLOOP_STREAMED_OUTER_SECOND: {
                return "Nested Loops (Streamed Outer: " + secondInputName + ")";
            }
            case INNER_MERGE: {
                return "Merge";
            }
            case FULL_OUTER_MERGE: {
                return "Full Outer Merge";
            }
            case LEFT_OUTER_MERGE: {
                return "Left Outer Merge";
            }
            case RIGHT_OUTER_MERGE: {
                return "Right Outer Merge";
            }
            case CO_GROUP: {
                return "Co-Group";
            }
        }
        return strategy.name();
    }

    public static String getShipStrategyString(ShipStrategyType shipType) {
        if (shipType == null) {
            return "(null)";
        }
        switch (shipType) {
            case NONE: {
                return "(none)";
            }
            case FORWARD: {
                return "Forward";
            }
            case BROADCAST: {
                return "Broadcast";
            }
            case PARTITION_HASH: {
                return "Hash Partition";
            }
            case PARTITION_RANGE: {
                return "Range Partition";
            }
            case PARTITION_RANDOM: {
                return "Redistribute";
            }
            case PARTITION_FORCED_REBALANCE: {
                return "Rebalance";
            }
            case PARTITION_CUSTOM: {
                return "Custom Partition";
            }
        }
        return shipType.name();
    }

    public static String getLocalStrategyString(LocalStrategy localStrategy) {
        if (localStrategy == null) {
            return "(null)";
        }
        switch (localStrategy) {
            case NONE: {
                return "(none)";
            }
            case SORT: {
                return "Sort";
            }
            case COMBININGSORT: {
                return "Sort (combining)";
            }
        }
        return localStrategy.name();
    }

    public static String getOptimizerPropertiesJson(JsonFactory jsonFactory, PlanNode node) {
        try {
            StringWriter writer = new StringWriter(256);
            JsonGenerator gen = jsonFactory.createGenerator((Writer)writer);
            OptimizerNode optNode = node.getOptimizerNode();
            gen.writeStartObject();
            if (node.getGlobalProperties() != null) {
                GlobalProperties gp = node.getGlobalProperties();
                gen.writeArrayFieldStart("global_properties");
                JsonMapper.addProperty(gen, "Partitioning", gp.getPartitioning().name());
                if (gp.getPartitioningFields() != null) {
                    JsonMapper.addProperty(gen, "Partitioned on", gp.getPartitioningFields().toString());
                }
                if (gp.getPartitioningOrdering() != null) {
                    JsonMapper.addProperty(gen, "Partitioning Order", gp.getPartitioningOrdering().toString());
                } else {
                    JsonMapper.addProperty(gen, "Partitioning Order", "(none)");
                }
                if (optNode.getUniqueFields() == null || optNode.getUniqueFields().size() == 0) {
                    JsonMapper.addProperty(gen, "Uniqueness", "not unique");
                } else {
                    JsonMapper.addProperty(gen, "Uniqueness", optNode.getUniqueFields().toString());
                }
                gen.writeEndArray();
            }
            if (node.getLocalProperties() != null) {
                LocalProperties lp = node.getLocalProperties();
                gen.writeArrayFieldStart("local_properties");
                if (lp.getOrdering() != null) {
                    JsonMapper.addProperty(gen, "Order", lp.getOrdering().toString());
                } else {
                    JsonMapper.addProperty(gen, "Order", "(none)");
                }
                if (lp.getGroupedFields() != null && lp.getGroupedFields().size() > 0) {
                    JsonMapper.addProperty(gen, "Grouped on", lp.getGroupedFields().toString());
                } else {
                    JsonMapper.addProperty(gen, "Grouping", "not grouped");
                }
                if (optNode.getUniqueFields() == null || optNode.getUniqueFields().size() == 0) {
                    JsonMapper.addProperty(gen, "Uniqueness", "not unique");
                } else {
                    JsonMapper.addProperty(gen, "Uniqueness", optNode.getUniqueFields().toString());
                }
                gen.writeEndArray();
            }
            gen.writeArrayFieldStart("estimates");
            JsonMapper.addProperty(gen, "Est. Output Size", optNode.getEstimatedOutputSize() == -1L ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(optNode.getEstimatedOutputSize(), "B"));
            JsonMapper.addProperty(gen, "Est. Cardinality", optNode.getEstimatedNumRecords() == -1L ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(optNode.getEstimatedNumRecords()));
            gen.writeEndArray();
            if (node.getNodeCosts() != null) {
                gen.writeArrayFieldStart("costs");
                JsonMapper.addProperty(gen, "Network", node.getNodeCosts().getNetworkCost() == -1.0 ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(node.getNodeCosts().getNetworkCost(), "B"));
                JsonMapper.addProperty(gen, "Disk I/O", node.getNodeCosts().getDiskCost() == -1.0 ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(node.getNodeCosts().getDiskCost(), "B"));
                JsonMapper.addProperty(gen, "CPU", node.getNodeCosts().getCpuCost() == -1.0 ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(node.getNodeCosts().getCpuCost(), ""));
                JsonMapper.addProperty(gen, "Cumulative Network", node.getCumulativeCosts().getNetworkCost() == -1.0 ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(node.getCumulativeCosts().getNetworkCost(), "B"));
                JsonMapper.addProperty(gen, "Cumulative Disk I/O", node.getCumulativeCosts().getDiskCost() == -1.0 ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(node.getCumulativeCosts().getDiskCost(), "B"));
                JsonMapper.addProperty(gen, "Cumulative CPU", node.getCumulativeCosts().getCpuCost() == -1.0 ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(node.getCumulativeCosts().getCpuCost(), ""));
                gen.writeEndArray();
            }
            if (optNode.getOperator().getCompilerHints() != null) {
                CompilerHints hints = optNode.getOperator().getCompilerHints();
                CompilerHints defaults = new CompilerHints();
                String size = hints.getOutputSize() == defaults.getOutputSize() ? "(none)" : String.valueOf(hints.getOutputSize());
                String card = hints.getOutputCardinality() == defaults.getOutputCardinality() ? "(none)" : String.valueOf(hints.getOutputCardinality());
                String width = hints.getAvgOutputRecordSize() == defaults.getAvgOutputRecordSize() ? "(none)" : String.valueOf(hints.getAvgOutputRecordSize());
                String filter = hints.getFilterFactor() == defaults.getFilterFactor() ? "(none)" : String.valueOf(hints.getFilterFactor());
                gen.writeArrayFieldStart("compiler_hints");
                JsonMapper.addProperty(gen, "Output Size (bytes)", size);
                JsonMapper.addProperty(gen, "Output Cardinality", card);
                JsonMapper.addProperty(gen, "Avg. Output Record Size (bytes)", width);
                JsonMapper.addProperty(gen, "Filter Factor", filter);
                gen.writeEndArray();
            }
            gen.writeEndObject();
            gen.close();
            return writer.toString();
        }
        catch (Exception e) {
            return "{}";
        }
    }

    private static void addProperty(JsonGenerator gen, String name, String value) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("name", name);
        gen.writeStringField("value", value);
        gen.writeEndObject();
    }
}

