/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.operators.base.OuterJoinOperatorBase;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.dag.TwoInputNode;
import org.apache.flink.optimizer.operators.AbstractJoinDescriptor;
import org.apache.flink.optimizer.operators.HashFullOuterJoinBuildFirstDescriptor;
import org.apache.flink.optimizer.operators.HashFullOuterJoinBuildSecondDescriptor;
import org.apache.flink.optimizer.operators.HashLeftOuterJoinBuildFirstDescriptor;
import org.apache.flink.optimizer.operators.HashLeftOuterJoinBuildSecondDescriptor;
import org.apache.flink.optimizer.operators.HashRightOuterJoinBuildFirstDescriptor;
import org.apache.flink.optimizer.operators.HashRightOuterJoinBuildSecondDescriptor;
import org.apache.flink.optimizer.operators.OperatorDescriptorDual;
import org.apache.flink.optimizer.operators.SortMergeFullOuterJoinDescriptor;
import org.apache.flink.optimizer.operators.SortMergeLeftOuterJoinDescriptor;
import org.apache.flink.optimizer.operators.SortMergeRightOuterJoinDescriptor;

public class OuterJoinNode
extends TwoInputNode {
    private List<OperatorDescriptorDual> dataProperties = this.getDataProperties();

    public OuterJoinNode(OuterJoinOperatorBase<?, ?, ?, ?> operator) {
        super((DualInputOperator<?, ?, ?, ?>)operator);
    }

    private List<OperatorDescriptorDual> getDataProperties() {
        List<OperatorDescriptorDual> list;
        OuterJoinOperatorBase<?, ?, ?, ?> operator = this.getOperator();
        OuterJoinOperatorBase.OuterJoinType type = operator.getOuterJoinType();
        JoinOperatorBase.JoinHint joinHint = operator.getJoinHint();
        joinHint = joinHint == null ? JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES : joinHint;
        switch (type) {
            case LEFT: {
                list = this.createLeftOuterJoinDescriptors(joinHint);
                break;
            }
            case RIGHT: {
                list = this.createRightOuterJoinDescriptors(joinHint);
                break;
            }
            case FULL: {
                list = this.createFullOuterJoinDescriptors(joinHint);
                break;
            }
            default: {
                throw new CompilerException("Unknown outer join type: " + type);
            }
        }
        Partitioner customPartitioner = operator.getCustomPartitioner();
        if (customPartitioner != null) {
            for (OperatorDescriptorDual desc : list) {
                ((AbstractJoinDescriptor)desc).setCustomPartitioner(customPartitioner);
            }
        }
        return list;
    }

    private List<OperatorDescriptorDual> createLeftOuterJoinDescriptors(JoinOperatorBase.JoinHint hint) {
        ArrayList<OperatorDescriptorDual> list = new ArrayList<OperatorDescriptorDual>();
        switch (hint) {
            case OPTIMIZER_CHOOSES: {
                list.add(new SortMergeLeftOuterJoinDescriptor(this.keys1, this.keys2, true));
                list.add(new HashLeftOuterJoinBuildSecondDescriptor(this.keys1, this.keys2, true, true));
                break;
            }
            case REPARTITION_SORT_MERGE: {
                list.add(new SortMergeLeftOuterJoinDescriptor(this.keys1, this.keys2, false));
                break;
            }
            case REPARTITION_HASH_SECOND: {
                list.add(new HashLeftOuterJoinBuildSecondDescriptor(this.keys1, this.keys2, false, true));
                break;
            }
            case BROADCAST_HASH_SECOND: {
                list.add(new HashLeftOuterJoinBuildSecondDescriptor(this.keys1, this.keys2, true, false));
                break;
            }
            case REPARTITION_HASH_FIRST: {
                list.add(new HashLeftOuterJoinBuildFirstDescriptor(this.keys1, this.keys2, false, true));
                break;
            }
            default: {
                throw new CompilerException("Invalid join hint: " + hint + " for left outer join");
            }
        }
        return list;
    }

    private List<OperatorDescriptorDual> createRightOuterJoinDescriptors(JoinOperatorBase.JoinHint hint) {
        ArrayList<OperatorDescriptorDual> list = new ArrayList<OperatorDescriptorDual>();
        switch (hint) {
            case OPTIMIZER_CHOOSES: {
                list.add(new SortMergeRightOuterJoinDescriptor(this.keys1, this.keys2, true));
                list.add(new HashRightOuterJoinBuildFirstDescriptor(this.keys1, this.keys2, true, true));
                break;
            }
            case REPARTITION_SORT_MERGE: {
                list.add(new SortMergeRightOuterJoinDescriptor(this.keys1, this.keys2, false));
                break;
            }
            case REPARTITION_HASH_FIRST: {
                list.add(new HashRightOuterJoinBuildFirstDescriptor(this.keys1, this.keys2, false, true));
                break;
            }
            case BROADCAST_HASH_FIRST: {
                list.add(new HashRightOuterJoinBuildFirstDescriptor(this.keys1, this.keys2, true, false));
                break;
            }
            case REPARTITION_HASH_SECOND: {
                list.add(new HashRightOuterJoinBuildSecondDescriptor(this.keys1, this.keys2, false, true));
                break;
            }
            default: {
                throw new CompilerException("Invalid join hint: " + hint + " for right outer join");
            }
        }
        return list;
    }

    private List<OperatorDescriptorDual> createFullOuterJoinDescriptors(JoinOperatorBase.JoinHint hint) {
        ArrayList<OperatorDescriptorDual> list = new ArrayList<OperatorDescriptorDual>();
        switch (hint) {
            case OPTIMIZER_CHOOSES: {
                list.add(new SortMergeFullOuterJoinDescriptor(this.keys1, this.keys2));
                break;
            }
            case REPARTITION_SORT_MERGE: {
                list.add(new SortMergeFullOuterJoinDescriptor(this.keys1, this.keys2));
                break;
            }
            case REPARTITION_HASH_FIRST: {
                list.add(new HashFullOuterJoinBuildFirstDescriptor(this.keys1, this.keys2));
                break;
            }
            case REPARTITION_HASH_SECOND: {
                list.add(new HashFullOuterJoinBuildSecondDescriptor(this.keys1, this.keys2));
                break;
            }
            default: {
                throw new CompilerException("Invalid join hint: " + hint + " for full outer join");
            }
        }
        return list;
    }

    public OuterJoinOperatorBase<?, ?, ?, ?> getOperator() {
        return (OuterJoinOperatorBase)super.getOperator();
    }

    @Override
    protected List<OperatorDescriptorDual> getPossibleProperties() {
        return this.dataProperties;
    }

    @Override
    public String getOperatorName() {
        return "Outer Join";
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        long card1 = this.getFirstPredecessorNode().getEstimatedNumRecords();
        long card2 = this.getSecondPredecessorNode().getEstimatedNumRecords();
        this.estimatedNumRecords = card1 < 0L || card2 < 0L ? -1L : Math.max(card1, card2);
        if (this.estimatedNumRecords >= 0L) {
            float width;
            float width1 = this.getFirstPredecessorNode().getEstimatedAvgWidthPerOutputRecord();
            float width2 = this.getSecondPredecessorNode().getEstimatedAvgWidthPerOutputRecord();
            float f = width = width1 <= 0.0f || width2 <= 0.0f ? -1.0f : width1 + width2;
            if (width > 0.0f) {
                this.estimatedOutputSize = (long)(width * (float)this.estimatedNumRecords);
            }
        }
    }
}

