/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileUtils {
    public static byte[] readEndOfFile(File file, long maxSize) throws IOException {
        byte[] fileContent;
        long readSize = maxSize;
        try (RandomAccessFile raFile = new RandomAccessFile(file, "r");){
            if (raFile.length() > maxSize) {
                raFile.seek(raFile.length() - maxSize);
            } else if (raFile.length() < maxSize) {
                readSize = (int)raFile.length();
            }
            fileContent = new byte[(int)readSize];
            raFile.read(fileContent);
        }
        return fileContent;
    }

    public static byte[] readFileFromOffset(File file, long startOffset, long maxSize) throws IOException {
        byte[] fileContent;
        if (file.length() < startOffset) {
            throw new IllegalArgumentException(String.format("The startOffset %s is great than the file length %s", startOffset, file.length()));
        }
        try (RandomAccessFile raFile = new RandomAccessFile(file, "r");){
            long readSize = Math.min(maxSize, file.length() - startOffset);
            raFile.seek(startOffset);
            fileContent = new byte[(int)readSize];
            raFile.read(fileContent);
        }
        return fileContent;
    }
}

