/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricRegistryConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MetricRegistryConfiguration.class);
    private final ScopeFormats scopeFormats;
    private final char delimiter;
    private final long queryServiceMessageSizeLimit;

    public MetricRegistryConfiguration(ScopeFormats scopeFormats, char delimiter, long queryServiceMessageSizeLimit) {
        this.scopeFormats = (ScopeFormats)Preconditions.checkNotNull((Object)scopeFormats);
        this.delimiter = delimiter;
        this.queryServiceMessageSizeLimit = queryServiceMessageSizeLimit;
    }

    public ScopeFormats getScopeFormats() {
        return this.scopeFormats;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public long getQueryServiceMessageSizeLimit() {
        return this.queryServiceMessageSizeLimit;
    }

    public static MetricRegistryConfiguration fromConfiguration(Configuration configuration, long maximumFrameSize) {
        char delim;
        ScopeFormats scopeFormats;
        try {
            scopeFormats = ScopeFormats.fromConfig(configuration);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse scope format, using default scope formats", (Throwable)e);
            scopeFormats = ScopeFormats.fromConfig(new Configuration());
        }
        try {
            delim = configuration.getString(MetricOptions.SCOPE_DELIMITER).charAt(0);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse delimiter, using default delimiter.", (Throwable)e);
            delim = '.';
        }
        long messageSizeLimitPadding = 256L;
        return new MetricRegistryConfiguration(scopeFormats, delim, maximumFrameSize - 256L);
    }
}

