/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProvider;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequest;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalSlotProviderImpl
implements PhysicalSlotProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PhysicalSlotProviderImpl.class);
    private final SlotSelectionStrategy slotSelectionStrategy;
    private final SlotPool slotPool;

    public PhysicalSlotProviderImpl(SlotSelectionStrategy slotSelectionStrategy, SlotPool slotPool) {
        this.slotSelectionStrategy = (SlotSelectionStrategy)Preconditions.checkNotNull((Object)slotSelectionStrategy);
        this.slotPool = (SlotPool)Preconditions.checkNotNull((Object)slotPool);
        slotPool.disableBatchSlotRequestTimeoutCheck();
    }

    @Override
    public CompletableFuture<PhysicalSlotRequest.Result> allocatePhysicalSlot(PhysicalSlotRequest physicalSlotRequest) {
        SlotRequestId slotRequestId = physicalSlotRequest.getSlotRequestId();
        SlotProfile slotProfile = physicalSlotRequest.getSlotProfile();
        ResourceProfile resourceProfile = slotProfile.getPhysicalSlotResourceProfile();
        LOG.debug("Received slot request [{}] with resource requirements: {}", (Object)slotRequestId, (Object)resourceProfile);
        Optional<PhysicalSlot> availablePhysicalSlot = this.tryAllocateFromAvailable(slotRequestId, slotProfile);
        CompletableFuture slotFuture = availablePhysicalSlot.map(CompletableFuture::completedFuture).orElseGet(() -> this.requestNewSlot(slotRequestId, resourceProfile, physicalSlotRequest.willSlotBeOccupiedIndefinitely()));
        return slotFuture.thenApply(physicalSlot -> new PhysicalSlotRequest.Result(slotRequestId, (PhysicalSlot)physicalSlot));
    }

    private Optional<PhysicalSlot> tryAllocateFromAvailable(SlotRequestId slotRequestId, SlotProfile slotProfile) {
        Collection slotInfoList = this.slotPool.getAvailableSlotsInformation().stream().map(SlotSelectionStrategy.SlotInfoAndResources::fromSingleSlot).collect(Collectors.toList());
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectedAvailableSlot = this.slotSelectionStrategy.selectBestSlotForProfile(slotInfoList, slotProfile);
        return selectedAvailableSlot.flatMap(slotInfoAndLocality -> this.slotPool.allocateAvailableSlot(slotRequestId, slotInfoAndLocality.getSlotInfo().getAllocationId(), slotProfile.getPhysicalSlotResourceProfile()));
    }

    private CompletableFuture<PhysicalSlot> requestNewSlot(SlotRequestId slotRequestId, ResourceProfile resourceProfile, boolean willSlotBeOccupiedIndefinitely) {
        if (willSlotBeOccupiedIndefinitely) {
            return this.slotPool.requestNewAllocatedSlot(slotRequestId, resourceProfile, null);
        }
        return this.slotPool.requestNewAllocatedBatchSlot(slotRequestId, resourceProfile);
    }

    @Override
    public void cancelSlotRequest(SlotRequestId slotRequestId, Throwable cause) {
        this.slotPool.releaseSlot(slotRequestId, cause);
    }
}

