/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.disk.FileChannelManagerImpl;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriterWithCallback;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileReader;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileSegmentReader;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.BulkBlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.FileSegment;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IOManager
implements AutoCloseable {
    protected static final Logger LOG = LoggerFactory.getLogger(IOManager.class);
    private static final String DIR_NAME_PREFIX = "io";
    private final FileChannelManager fileChannelManager;

    protected IOManager(String[] tempDirs) {
        this.fileChannelManager = new FileChannelManagerImpl((String[])Preconditions.checkNotNull((Object)tempDirs), DIR_NAME_PREFIX);
        if (LOG.isInfoEnabled()) {
            LOG.info("Created a new {} for spilling of task related data to disk (joins, sorting, ...). Used directories:\n\t{}", (Object)FileChannelManager.class.getSimpleName(), (Object)Arrays.stream(this.fileChannelManager.getPaths()).map(File::getAbsolutePath).collect(Collectors.joining("\n\t")));
        }
    }

    @Override
    public void close() throws Exception {
        this.fileChannelManager.close();
    }

    public FileIOChannel.ID createChannel() {
        return this.fileChannelManager.createChannel();
    }

    public FileIOChannel.Enumerator createChannelEnumerator() {
        return this.fileChannelManager.createChannelEnumerator();
    }

    public static void deleteChannel(FileIOChannel.ID channel) {
        if (channel != null && channel.getPathFile().exists() && !channel.getPathFile().delete()) {
            LOG.warn("IOManager failed to delete temporary file {}", (Object)channel.getPath());
        }
    }

    public File[] getSpillingDirectories() {
        return this.fileChannelManager.getPaths();
    }

    public String[] getSpillingDirectoriesPaths() {
        File[] paths = this.fileChannelManager.getPaths();
        String[] strings = new String[paths.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = paths[i].getAbsolutePath();
        }
        return strings;
    }

    public BlockChannelWriter<MemorySegment> createBlockChannelWriter(FileIOChannel.ID channelID) throws IOException {
        return this.createBlockChannelWriter(channelID, new LinkedBlockingQueue<MemorySegment>());
    }

    public abstract BlockChannelWriter<MemorySegment> createBlockChannelWriter(FileIOChannel.ID var1, LinkedBlockingQueue<MemorySegment> var2) throws IOException;

    public abstract BlockChannelWriterWithCallback<MemorySegment> createBlockChannelWriter(FileIOChannel.ID var1, RequestDoneCallback<MemorySegment> var2) throws IOException;

    public BlockChannelReader<MemorySegment> createBlockChannelReader(FileIOChannel.ID channelID) throws IOException {
        return this.createBlockChannelReader(channelID, new LinkedBlockingQueue<MemorySegment>());
    }

    public abstract BlockChannelReader<MemorySegment> createBlockChannelReader(FileIOChannel.ID var1, LinkedBlockingQueue<MemorySegment> var2) throws IOException;

    public abstract BufferFileWriter createBufferFileWriter(FileIOChannel.ID var1) throws IOException;

    public abstract BufferFileReader createBufferFileReader(FileIOChannel.ID var1, RequestDoneCallback<Buffer> var2) throws IOException;

    public abstract BufferFileSegmentReader createBufferFileSegmentReader(FileIOChannel.ID var1, RequestDoneCallback<FileSegment> var2) throws IOException;

    public abstract BulkBlockChannelReader createBulkBlockChannelReader(FileIOChannel.ID var1, List<MemorySegment> var2, int var3) throws IOException;
}

