/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import breeze.linalg.SparseVector;
import breeze.storage.Zero$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001B\u000f\u001f\u0001%B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t%\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005m!A!\b\u0001BC\u0002\u0013\u00051\b\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003=\u0011!Q\u0005A!b\u0001\n\u0003Y\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u000bM\u0003A\u0011\u0001+\t\u000bq\u0003A\u0011I/\t\u000b%\u0004A\u0011I&\t\u000b)\u0004A\u0011I6\t\r1\u0004A\u0011\t\u0012n\u0011\u0015!\b\u0001\"\u0011v\u0011\u0015A\b\u0001\"\u0011z\u0011\u001d\t)\u0001\u0001C!\u0003\u000fAa!!\u0003\u0001\t\u0003*\u0004BBA\u0006\u0001\u0011\u0005S\u0007\u0003\u0005\u0002\u000e\u0001!\tEHA\b\u0011\u0019\t)\u0002\u0001C!k!A\u0011q\u0003\u0001\u0005\u0002\t\nI\u0002\u0003\u0006\u0002$\u0001\t\n\u0011\"\u0001#\u0003KA\u0001\"!\u000f\u0001\t\u0003\u0012\u00131\b\u0005\t\u0003+\u0002A\u0011\t\u0012\u0002<!A\u0011q\u000b\u0001\u0005B\u0001\nIfB\u0004\u0002dyA\t!!\u001a\u0007\ruq\u0002\u0012AA4\u0011\u0019\u0019\u0016\u0004\"\u0001\u0002z!9\u00111P\r\u0005\u0002\u0005u\u0004\"CAI3\u0005\u0005I\u0011BAJ\u00051\u0019\u0006/\u0019:tKZ+7\r^8s\u0015\ty\u0002%\u0001\u0004mS:\fGn\u001a\u0006\u0003C\t\n!!\u001c7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001UA\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0007CA\u00193\u001b\u0005q\u0012BA\u001a\u001f\u0005\u00191Vm\u0019;pe\u0006!1/\u001b>f+\u00051\u0004CA\u00168\u0013\tADFA\u0002J]R\fQa]5{K\u0002\nq!\u001b8eS\u000e,7/F\u0001=!\rYSHN\u0005\u0003}1\u0012Q!\u0011:sCfD3a\u0001!G!\t\tE)D\u0001C\u0015\t\u0019%%\u0001\u0006b]:|G/\u0019;j_:L!!\u0012\"\u0003\u000bMKgnY3\"\u0003\u001d\u000bQA\r\u00181]A\n\u0001\"\u001b8eS\u000e,7\u000f\t\u0015\u0004\t\u00013\u0015A\u0002<bYV,7/F\u0001M!\rYS(\u0014\t\u0003W9K!a\u0014\u0017\u0003\r\u0011{WO\u00197fQ\r)\u0001IR\u0001\bm\u0006dW/Z:!Q\r1\u0001IR\u0001\u0007y%t\u0017\u000e\u001e \u0015\tU3v+\u0017\t\u0003c\u0001AQ\u0001N\u0004A\u0002YBQAO\u0004A\u0002qB3a\u0016!G\u0011\u0015Qu\u00011\u0001MQ\rI\u0006I\u0012\u0015\u0004\u000f\u00013\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003y\u0003\"a\u00184\u000f\u0005\u0001$\u0007CA1-\u001b\u0005\u0011'BA2)\u0003\u0019a$o\\8u}%\u0011Q\rL\u0001\u0007!J,G-\u001a4\n\u0005\u001dD'AB*ue&twM\u0003\u0002fY\u00059Ao\\!se\u0006L\u0018\u0001B2paf,\u0012!V\u0001\tCN\u0014%/Z3{KV\ta\u000eE\u0002pg6k\u0011\u0001\u001d\u0006\u0003?ET\u0011A]\u0001\u0007EJ,WM_3\n\u0005M\u0002\u0018!B1qa2LHCA'w\u0011\u00159H\u00021\u00017\u0003\u0005I\u0017AB3rk\u0006d7\u000f\u0006\u0002{{B\u00111f_\u0005\u0003y2\u0012qAQ8pY\u0016\fg\u000eC\u0003\u007f\u001b\u0001\u0007q0A\u0003pi\",'\u000fE\u0002,\u0003\u0003I1!a\u0001-\u0005\r\te._\u0001\tQ\u0006\u001c\bnQ8eKR\ta'\u0001\u0006ok6\f5\r^5wKN\f1B\\;n\u001d>t'0\u001a:pg\u0006\u0001Bo\\*qCJ\u001cXmV5uQNK'0\u001a\u000b\u0004+\u0006E\u0001BBA\n#\u0001\u0007a'A\u0002o]j\fa!\u0019:h[\u0006D\u0018!B:mS\u000e,G#B+\u0002\u001c\u0005}\u0001BBA\u000f'\u0001\u0007A(A\btK2,7\r^3e\u0013:$\u0017nY3t\u0011!\t\tc\u0005I\u0001\u0002\u0004Q\u0018AB:peR,G-A\btY&\u001cW\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t9CK\u0002{\u0003SY#!a\u000b\u0011\t\u00055\u0012QG\u0007\u0003\u0003_QA!!\r\u00024\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u00072JA!a\u000e\u00020\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0011%$XM]1u_J,\"!!\u0010\u0011\r\u0005}\u0012\u0011JA(\u001d\u0011\t\t%!\u0012\u000f\u0007\u0005\f\u0019%C\u0001.\u0013\r\t9\u0005L\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY%!\u0014\u0003\u0011%#XM]1u_JT1!a\u0012-!\u0015Y\u0013\u0011\u000b\u001cN\u0013\r\t\u0019\u0006\f\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u001d\u0005\u001cG/\u001b<f\u0013R,'/\u0019;pe\u0006qq-\u001a;TSj,\u0017J\u001c\"zi\u0016\u001cXCAA.!\rY\u0013QL\u0005\u0004\u0003?b#\u0001\u0002'p]\u001eD3\u0001\u0001!G\u00031\u0019\u0006/\u0019:tKZ+7\r^8s!\t\t\u0014d\u0005\u0003\u001aU\u0005%\u0004\u0003BA6\u0003kj!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\u0003S>T!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003o\niG\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002f\u00059QO\\1qa2LH\u0003BA@\u0003\u0017\u0003RaKAA\u0003\u000bK1!a!-\u0005\u0019y\u0005\u000f^5p]B11&a\"7y1K1!!#-\u0005\u0019!V\u000f\u001d7fg!1\u0011QR\u000eA\u0002U\u000b!a\u001d<)\u0007m\u0001e)\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002\u0016B!\u0011qSAO\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006E\u0014\u0001\u00027b]\u001eLA!a(\u0002\u001a\n1qJ\u00196fGRD3!\u0007!GQ\rA\u0002I\u0012")
public class SparseVector
implements Vector {
    private final int size;
    private final int[] indices;
    private final double[] values;

    public static Option<Tuple3<Object, int[], double[]>> unapply(SparseVector sv) {
        return SparseVector$.MODULE$.unapply(sv);
    }

    @Override
    public void foreach(Function2<Object, Object, BoxedUnit> f) {
        Vector.foreach$(this, f);
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        Vector.foreachActive$(this, f);
    }

    @Override
    public void foreachNonZero(Function2<Object, Object, BoxedUnit> f) {
        Vector.foreachNonZero$(this, f);
    }

    @Override
    public SparseVector toSparse() {
        return Vector.toSparse$(this);
    }

    @Override
    public DenseVector toDense() {
        return Vector.toDense$(this);
    }

    @Override
    public Vector compressed() {
        return Vector.compressed$(this);
    }

    @Override
    public Vector compressedWithNNZ(int nnz) {
        return Vector.compressedWithNNZ$(this, nnz);
    }

    @Override
    public double dot(Vector v) {
        return Vector.dot$(this, v);
    }

    @Override
    public Iterator<Tuple2<Object, Object>> nonZeroIterator() {
        return Vector.nonZeroIterator$(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public String toString() {
        return "(" + this.size() + "," + Predef$.MODULE$.wrapIntArray(this.indices()).mkString("[", ",", "]") + "," + Predef$.MODULE$.wrapDoubleArray(this.values()).mkString("[", ",", "]") + ")";
    }

    @Override
    public double[] toArray() {
        double[] data = new double[this.size()];
        int nnz = this.indices().length;
        for (int i = 0; i < nnz; ++i) {
            data[this.indices()[i]] = this.values()[i];
        }
        return data;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this.size(), (int[])this.indices().clone(), (double[])this.values().clone());
    }

    @Override
    public breeze.linalg.Vector<Object> asBreeze() {
        return new SparseVector.mcD.sp(this.indices(), this.values(), this.size(), Zero$.MODULE$.DoubleZero());
    }

    @Override
    public double apply(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + i + " out of bounds [0, " + this.size() + ")");
        }
        int j = Arrays.binarySearch(this.indices(), i);
        if (j < 0) {
            return 0.0;
        }
        return this.values()[j];
    }

    @Override
    public boolean equals(Object other) {
        return Vector.equals$(this, other);
    }

    @Override
    public int hashCode() {
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int k = 0; k < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++k) {
            double v = this.values()[k];
            if (v == 0.0) continue;
            int i = this.indices()[k];
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(v);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return result;
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = IntRef.create((int)0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(this.values()), (Function1)(JFunction1.mcVD.sp & Serializable)v -> {
            if (v != 0.0) {
                ++nnz$3.elem;
                return;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparseWithSize(int nnz) {
        if (nnz == this.numActives()) {
            return this;
        }
        int[] ii = new int[nnz];
        double[] vv = new double[nnz];
        IntRef k = IntRef.create((int)0);
        this.foreachNonZero((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable)(i, v) -> {
            ii$2[k$2.elem] = i;
            vv$2[k$2.elem] = v;
            ++k$2.elem;
        });
        return new SparseVector(this.size(), ii, vv);
    }

    @Override
    public int argmax() {
        int maxIdx;
        block5: {
            int k;
            int na;
            block6: {
                int k2;
                if (this.size() == 0) {
                    return -1;
                }
                if (this.numActives() == 0) {
                    return 0;
                }
                maxIdx = this.indices()[0];
                double maxValue = this.values()[0];
                int maxJ = 0;
                na = this.numActives();
                for (int j = 1; j < na; ++j) {
                    double v = this.values()[j];
                    if (!(v > maxValue)) continue;
                    maxValue = v;
                    maxIdx = this.indices()[j];
                    maxJ = j;
                }
                if (!(maxValue <= 0.0) || na >= this.size()) break block5;
                if (maxValue != 0.0) break block6;
                if (maxJ >= maxIdx) break block5;
                for (k2 = 0; k2 < maxJ && this.indices()[k2] == k2; ++k2) {
                }
                maxIdx = k2;
                break block5;
            }
            for (k = 0; k < na && this.indices()[k] == k; ++k) {
            }
            maxIdx = k;
        }
        return maxIdx;
    }

    public SparseVector slice(int[] selectedIndices, boolean sorted) {
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        int ns = selectedIndices.length;
        ArrayBuilder indexBuff = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Int());
        ArrayBuilder valueBuff = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Double());
        if (sorted) {
            int nk = localIndices.length;
            int s = 0;
            for (int k = 0; k < nk && s < ns; ++k) {
                int i = localIndices[k];
                double v = localValues[k];
                if (v == 0.0) continue;
                while (s < ns && selectedIndices[s] < i) {
                    ++s;
                }
                if (s >= ns || selectedIndices[s] != i) continue;
                indexBuff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)s));
                valueBuff.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v));
                ++s;
            }
        } else {
            for (int s = 0; s < ns; ++s) {
                BoxedUnit boxedUnit;
                int j = Arrays.binarySearch(localIndices, selectedIndices[s]);
                if (j >= 0) {
                    double v = localValues[j];
                    if (v != 0.0) {
                        indexBuff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)s));
                        boxedUnit = valueBuff.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v));
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        return new SparseVector(ns, (int[])indexBuff.result(), (double[])valueBuff.result());
    }

    public boolean slice$default$2() {
        return false;
    }

    @Override
    public Iterator<Tuple2<Object, Object>> iterator() {
        int localSize = this.size();
        int localNumActives = this.numActives();
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        return new Iterator<Tuple2<Object, Object>>(null, localIndices, localSize, localNumActives, localValues){
            private int i;
            private int j;
            private int k;
            private final int[] localIndices$1;
            private final int localSize$1;
            private final int localNumActives$1;
            private final double[] localValues$2;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<Tuple2<Object, Object>> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<Tuple2<Object, Object>> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<Tuple2<Object, Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> partition(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<Tuple2<Object, Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<Tuple2<Object, Object>> filter(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> filterNot(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> filterImpl(Function1<Tuple2<Object, Object>, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<Tuple2<Object, Object>> withFilter(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<Object, Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<Tuple2<Object, Object>> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<Tuple2<Object, Object>> distinctBy(Function1<Tuple2<Object, Object>, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<Tuple2<Object, Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<Object, Object>, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<Tuple2<Object, Object>, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<Tuple2<Object, Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<Object, Object>> takeWhile(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<Object, Object>> dropWhile(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> span(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<Object, Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<Tuple2<Object, Object>, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<Tuple2<Object, Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<Tuple2<Object, Object>> tapEach(Function1<Tuple2<Object, Object>, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<Tuple2<Object, Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<Tuple2<Object, Object>, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<Tuple2<Object, Object>, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<Tuple2<Object, Object>, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<Tuple2<Object, Object>, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<Tuple2<Object, Object>> find(Function1<Tuple2<Object, Object>, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<Object, Object>, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<Object, Object>, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object dest) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest);
            }

            public <B> int copyToArray(Object dest, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start);
            }

            public <B> int copyToArray(Object dest, int start, int n) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start, (int)n);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Tuple2<Object, Object>> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Tuple2<Object, Object>> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering ord) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<Tuple2<Object, Object>> maxByOption(Function1<Tuple2<Object, Object>, B> f, Ordering<B> ord) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
            }

            public Object minBy(Function1 f, Ordering ord) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<Tuple2<Object, Object>> minByOption(Function1<Tuple2<Object, Object>, B> f, Ordering<B> ord) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<Object, Object>, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<Object, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<Tuple2<Object, Object>, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<Tuple2<Object, Object>, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<Tuple2<Object, Object>> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<Tuple2<Object, Object>> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public scala.collection.immutable.Vector<Tuple2<Object, Object>> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<Tuple2<Object, Object>, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<Tuple2<Object, Object>> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<Tuple2<Object, Object>> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<Tuple2<Object, Object>> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<Tuple2<Object, Object>> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<Tuple2<Object, Object>, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            private int j() {
                return this.j;
            }

            private void j_$eq(int x$1) {
                this.j = x$1;
            }

            private int k() {
                return this.k;
            }

            private void k_$eq(int x$1) {
                this.k = x$1;
            }

            public boolean hasNext() {
                return this.i() < this.localSize$1;
            }

            public Tuple2<Object, Object> next() {
                double d;
                if (this.i() == this.k()) {
                    this.j_$eq(this.j() + 1);
                    this.k_$eq(this.j() < this.localNumActives$1 ? this.localIndices$1[this.j()] : -1);
                    d = this.localValues$2[this.j() - 1];
                } else {
                    d = 0.0;
                }
                double v = d;
                this.i_$eq(this.i() + 1);
                return new Tuple2.mcID.sp(this.i() - 1, v);
            }
            {
                this.localIndices$1 = localIndices$1;
                this.localSize$1 = localSize$1;
                this.localNumActives$1 = localNumActives$1;
                this.localValues$2 = localValues$2;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.i = 0;
                this.j = 0;
                this.k = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.intArrayOps(localIndices$1)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$k$1()}, serializedLambda);
            }
        };
    }

    @Override
    public Iterator<Tuple2<Object, Object>> activeIterator() {
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        return package$.MODULE$.Iterator().tabulate(this.numActives(), (Function1 & Serializable)j -> SparseVector.$anonfun$activeIterator$1(localIndices, localValues, BoxesRunTime.unboxToInt((Object)j)));
    }

    @Override
    public long getSizeInBytes() {
        return Vectors$.MODULE$.getSparseSize(this.values().length);
    }

    public static final /* synthetic */ Tuple2 $anonfun$activeIterator$1(int[] localIndices$2, double[] localValues$3, int j) {
        return new Tuple2.mcID.sp(localIndices$2[j], localValues$3[j]);
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this.size = size;
        this.indices = indices;
        this.values = values;
        Vector.$init$(this);
        Predef$.MODULE$.require(size >= 0, (Function0 & Serializable)() -> "The size of the requested sparse vector must be no less than 0.");
        Predef$.MODULE$.require(indices.length == values.length, (Function0 & Serializable)() -> "Sparse vectors require that the dimension of the indices match the dimension of the values. You provided " + this.indices().length + " indices and  " + this.values().length + " values.");
        Predef$.MODULE$.require(indices.length <= size, (Function0 & Serializable)() -> "You provided " + this.indices().length + " indices and values, which exceeds the specified vector size " + this.size() + ".");
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.intArrayOps(indices))) {
            Predef$.MODULE$.require(indices[0] >= 0, (Function0 & Serializable)() -> "Found negative index: " + this.indices()[0] + ".");
        }
        IntRef prev = IntRef.create((int)-1);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(indices), (Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Predef$.MODULE$.require(prev$1.elem < i, (Function0 & Serializable)() -> "Index " + i + " follows " + prev$1.elem + " and is not strictly increasing");
            prev$1.elem = i;
        });
        Predef$.MODULE$.require(prev.elem < size, (Function0 & Serializable)() -> "Index " + prev$1.elem + " out of bounds for vector of size " + this.size());
    }
}

