/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.LDAExample;
import org.apache.spark.examples.mllib.LDAExample$;
import org.apache.spark.examples.mllib.LDAExample$Params$;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.feature.CountVectorizer;
import org.apache.spark.ml.feature.CountVectorizerModel;
import org.apache.spark.ml.feature.RegexTokenizer;
import org.apache.spark.ml.feature.StopWordsRemover;
import org.apache.spark.mllib.clustering.DistributedLDAModel;
import org.apache.spark.mllib.clustering.EMLDAOptimizer;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class LDAExample$ {
    public static final LDAExample$ MODULE$ = new LDAExample$();

    public void main(String[] args) {
        LDAExample.Params defaultParams = new LDAExample.Params(LDAExample$Params$.MODULE$.apply$default$1(), LDAExample$Params$.MODULE$.apply$default$2(), LDAExample$Params$.MODULE$.apply$default$3(), LDAExample$Params$.MODULE$.apply$default$4(), LDAExample$Params$.MODULE$.apply$default$5(), LDAExample$Params$.MODULE$.apply$default$6(), LDAExample$Params$.MODULE$.apply$default$7(), LDAExample$Params$.MODULE$.apply$default$8(), LDAExample$Params$.MODULE$.apply$default$9(), LDAExample$Params$.MODULE$.apply$default$10());
        OptionParser<LDAExample.Params> parser = new OptionParser<LDAExample.Params>(defaultParams){

            public static final /* synthetic */ LDAExample.Params $anonfun$new$1(int x, LDAExample.Params c) {
                int x$1 = x;
                scala.collection.immutable.Seq<String> x$2 = c.copy$default$1();
                int x$3 = c.copy$default$3();
                double x$4 = c.copy$default$4();
                double x$5 = c.copy$default$5();
                int x$6 = c.copy$default$6();
                String x$7 = c.copy$default$7();
                String x$8 = c.copy$default$8();
                Option<String> x$9 = c.copy$default$9();
                int x$10 = c.copy$default$10();
                return c.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
            }

            public static final /* synthetic */ LDAExample.Params $anonfun$new$2(int x, LDAExample.Params c) {
                int x$11 = x;
                scala.collection.immutable.Seq<String> x$12 = c.copy$default$1();
                int x$13 = c.copy$default$2();
                double x$14 = c.copy$default$4();
                double x$15 = c.copy$default$5();
                int x$16 = c.copy$default$6();
                String x$17 = c.copy$default$7();
                String x$18 = c.copy$default$8();
                Option<String> x$19 = c.copy$default$9();
                int x$20 = c.copy$default$10();
                return c.copy(x$12, x$13, x$11, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
            }

            public static final /* synthetic */ LDAExample.Params $anonfun$new$3(double x, LDAExample.Params c) {
                double x$21 = x;
                scala.collection.immutable.Seq<String> x$22 = c.copy$default$1();
                int x$23 = c.copy$default$2();
                int x$24 = c.copy$default$3();
                double x$25 = c.copy$default$5();
                int x$26 = c.copy$default$6();
                String x$27 = c.copy$default$7();
                String x$28 = c.copy$default$8();
                Option<String> x$29 = c.copy$default$9();
                int x$30 = c.copy$default$10();
                return c.copy(x$22, x$23, x$24, x$21, x$25, x$26, x$27, x$28, x$29, x$30);
            }

            public static final /* synthetic */ LDAExample.Params $anonfun$new$4(double x, LDAExample.Params c) {
                double x$31 = x;
                scala.collection.immutable.Seq<String> x$32 = c.copy$default$1();
                int x$33 = c.copy$default$2();
                int x$34 = c.copy$default$3();
                double x$35 = c.copy$default$4();
                int x$36 = c.copy$default$6();
                String x$37 = c.copy$default$7();
                String x$38 = c.copy$default$8();
                Option<String> x$39 = c.copy$default$9();
                int x$40 = c.copy$default$10();
                return c.copy(x$32, x$33, x$34, x$35, x$31, x$36, x$37, x$38, x$39, x$40);
            }

            public static final /* synthetic */ LDAExample.Params $anonfun$new$5(int x, LDAExample.Params c) {
                int x$41 = x;
                scala.collection.immutable.Seq<String> x$42 = c.copy$default$1();
                int x$43 = c.copy$default$2();
                int x$44 = c.copy$default$3();
                double x$45 = c.copy$default$4();
                double x$46 = c.copy$default$5();
                String x$47 = c.copy$default$7();
                String x$48 = c.copy$default$8();
                Option<String> x$49 = c.copy$default$9();
                int x$50 = c.copy$default$10();
                return c.copy(x$42, x$43, x$44, x$45, x$46, x$41, x$47, x$48, x$49, x$50);
            }

            public static final /* synthetic */ LDAExample.Params $anonfun$new$9(int x, LDAExample.Params c) {
                int x$81 = x;
                scala.collection.immutable.Seq<String> x$82 = c.copy$default$1();
                int x$83 = c.copy$default$2();
                int x$84 = c.copy$default$3();
                double x$85 = c.copy$default$4();
                double x$86 = c.copy$default$5();
                int x$87 = c.copy$default$6();
                String x$88 = c.copy$default$7();
                String x$89 = c.copy$default$8();
                Option<String> x$90 = c.copy$default$9();
                return c.copy(x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$81);
            }
            {
                this.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"LDAExample: an example LDA app for plain text data."}));
                this.opt("k", Read$.MODULE$.intRead()).text("number of topics. default: " + defaultParams$1.k()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$1(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("maxIterations", Read$.MODULE$.intRead()).text("number of iterations of learning. default: " + defaultParams$1.maxIterations()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("docConcentration", Read$.MODULE$.doubleRead()).text("amount of topic smoothing to use (> 1.0) (-1=auto).  default: " + defaultParams$1.docConcentration()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$3(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("topicConcentration", Read$.MODULE$.doubleRead()).text("amount of term (word) smoothing to use (> 1.0) (-1=auto).  default: " + defaultParams$1.topicConcentration()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$4(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("vocabSize", Read$.MODULE$.intRead()).text("number of distinct word types to use, chosen by frequency. (-1=all)  default: " + defaultParams$1.vocabSize()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$5(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("stopwordFile", Read$.MODULE$.stringRead()).text("filepath for a list of stopwords. Note: This must fit on a single machine.  default: " + defaultParams$1.stopwordFile()).action((Function2 & Serializable)(x, c) -> {
                    String x$51 = x;
                    scala.collection.immutable.Seq<String> x$52 = c.copy$default$1();
                    int x$53 = c.copy$default$2();
                    int x$54 = c.copy$default$3();
                    double x$55 = c.copy$default$4();
                    double x$56 = c.copy$default$5();
                    int x$57 = c.copy$default$6();
                    String x$58 = c.copy$default$8();
                    Option<String> x$59 = c.copy$default$9();
                    int x$60 = c.copy$default$10();
                    return c.copy(x$52, x$53, x$54, x$55, x$56, x$57, x$51, x$58, x$59, x$60);
                });
                this.opt("algorithm", Read$.MODULE$.stringRead()).text("inference algorithm to use. em and online are supported. default: " + defaultParams$1.algorithm()).action((Function2 & Serializable)(x, c) -> {
                    String x$61 = x;
                    scala.collection.immutable.Seq<String> x$62 = c.copy$default$1();
                    int x$63 = c.copy$default$2();
                    int x$64 = c.copy$default$3();
                    double x$65 = c.copy$default$4();
                    double x$66 = c.copy$default$5();
                    int x$67 = c.copy$default$6();
                    String x$68 = c.copy$default$7();
                    Option<String> x$69 = c.copy$default$9();
                    int x$70 = c.copy$default$10();
                    return c.copy(x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$61, x$69, x$70);
                });
                this.opt("checkpointDir", Read$.MODULE$.stringRead()).text("Directory for checkpointing intermediate results.  Checkpointing helps with recovery and eliminates temporary shuffle files on disk.  default: " + defaultParams$1.checkpointDir()).action((Function2 & Serializable)(x, c) -> {
                    Some x$71 = new Some(x);
                    scala.collection.immutable.Seq<String> x$72 = c.copy$default$1();
                    int x$73 = c.copy$default$2();
                    int x$74 = c.copy$default$3();
                    double x$75 = c.copy$default$4();
                    double x$76 = c.copy$default$5();
                    int x$77 = c.copy$default$6();
                    String x$78 = c.copy$default$7();
                    String x$79 = c.copy$default$8();
                    int x$80 = c.copy$default$10();
                    return c.copy(x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, (Option<String>)x$71, x$80);
                });
                this.opt("checkpointInterval", Read$.MODULE$.intRead()).text("Iterations between each checkpoint.  Only used if checkpointDir is set. default: " + defaultParams$1.checkpointInterval()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)x), c));
                this.arg("<input>...", Read$.MODULE$.stringRead()).text("input paths (directories) to plain text corpora.  Each text file line should hold 1 document.").unbounded().required().action((Function2 & Serializable)(x, c) -> c.copy((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)c.input().$colon$plus(x)), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(java.lang.Object org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$10(java.lang.String org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$3$adapted(java.lang.Object org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$4$adapted(java.lang.Object org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$5$adapted(java.lang.Object org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$6(java.lang.String org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$7(java.lang.String org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$8(java.lang.String org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$9$adapted(java.lang.Object org.apache.spark.examples.mllib.LDAExample$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            LDAExample.Params params = (LDAExample.Params)some.value();
            this.run(params);
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    private void run(LDAExample.Params params) {
        EMLDAOptimizer eMLDAOptimizer;
        LDA lda;
        long actualCorpusSize;
        String[] vocabArray;
        RDD corpus;
        SparkContext sc;
        block7: {
            SparkConf conf = new SparkConf().setAppName("LDAExample with " + params);
            sc = new SparkContext(conf);
            Configurator.setRootLevel((Level)Level.WARN);
            long preprocessStart = System.nanoTime();
            Tuple3<RDD<Tuple2<Object, Vector>>, String[], Object> tuple3 = this.preprocess(sc, params.input(), params.vocabSize(), params.stopwordFile());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            RDD corpus2 = (RDD)tuple3._1();
            String[] vocabArray2 = (String[])tuple3._2();
            long actualNumTokens = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)corpus2, (Object)vocabArray2, (Object)BoxesRunTime.boxToLong((long)actualNumTokens));
            corpus = (RDD)tuple32._1();
            vocabArray = (String[])tuple32._2();
            long actualNumTokens2 = BoxesRunTime.unboxToLong((Object)tuple32._3());
            corpus.cache();
            actualCorpusSize = corpus.count();
            int actualVocabSize = vocabArray.length;
            double preprocessElapsed = (double)(System.nanoTime() - preprocessStart) / 1.0E9;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Corpus summary:");
            Predef$.MODULE$.println((Object)("\t Training set size: " + actualCorpusSize + " documents"));
            Predef$.MODULE$.println((Object)("\t Vocabulary size: " + actualVocabSize + " terms"));
            Predef$.MODULE$.println((Object)("\t Training set size: " + actualNumTokens2 + " tokens"));
            Predef$.MODULE$.println((Object)("\t Preprocessing time: " + preprocessElapsed + " sec"));
            Predef$.MODULE$.println();
            lda = new LDA();
            String string = params.algorithm().toLowerCase(Locale.ROOT);
            switch (string == null ? 0 : string.hashCode()) {
                case -1012222381: {
                    if (!"online".equals(string)) break;
                    eMLDAOptimizer = new OnlineLDAOptimizer().setMiniBatchFraction(0.05 + 1.0 / (double)actualCorpusSize);
                    break block7;
                }
                case 3240: {
                    if (!"em".equals(string)) break;
                    eMLDAOptimizer = new EMLDAOptimizer();
                    break block7;
                }
            }
            throw new IllegalArgumentException("Only em, online are supported but got " + params.algorithm() + ".");
        }
        EMLDAOptimizer optimizer = eMLDAOptimizer;
        lda.setOptimizer((LDAOptimizer)optimizer).setK(params.k()).setMaxIterations(params.maxIterations()).setDocConcentration(params.docConcentration()).setTopicConcentration(params.topicConcentration()).setCheckpointInterval(params.checkpointInterval());
        if (params.checkpointDir().nonEmpty()) {
            sc.setCheckpointDir((String)params.checkpointDir().get());
        }
        long startTime = System.nanoTime();
        LDAModel ldaModel = lda.run(corpus);
        double elapsed = (double)(System.nanoTime() - startTime) / 1.0E9;
        Predef$.MODULE$.println((Object)"Finished training LDA model.  Summary:");
        Predef$.MODULE$.println((Object)("\t Training time: " + elapsed + " sec"));
        LDAModel lDAModel = ldaModel;
        if (lDAModel instanceof DistributedLDAModel) {
            DistributedLDAModel distributedLDAModel = (DistributedLDAModel)lDAModel;
            double avgLogLikelihood = distributedLDAModel.logLikelihood() / (double)actualCorpusSize;
            Predef$.MODULE$.println((Object)("\t Training data average log likelihood: " + avgLogLikelihood));
            Predef$.MODULE$.println();
        }
        Tuple2[] topicIndices = ldaModel.describeTopics(10);
        Tuple2[][] topics = (Tuple2[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])topicIndices), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int[] terms = (int[])tuple2._1();
                double[] termWeights = (double[])tuple2._2();
                return (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.intArrayOps(terms), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(termWeights))), (Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        int term = tuple2._1$mcI$sp();
                        double weight = tuple2._2$mcD$sp();
                        return new Tuple2((Object)vocabArray[term], (Object)BoxesRunTime.boxToDouble((double)weight));
                    }
                    throw new MatchError((Object)tuple2);
                }, ClassTag$.MODULE$.apply(Tuple2.class));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
        Predef$.MODULE$.println((Object)(params.k() + " topics:"));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])topics))), (Function1 & Serializable)x0$3 -> {
            LDAExample$.$anonfun$run$3(x0$3);
            return BoxedUnit.UNIT;
        });
        sc.stop();
    }

    private Tuple3<RDD<Tuple2<Object, Vector>>, String[], Object> preprocess(SparkContext sc, scala.collection.immutable.Seq<String> paths, int vocabSize, String stopwordFile) {
        String[] stringArray;
        SparkSession spark = SparkSession$.MODULE$.builder().sparkContext(sc).getOrCreate();
        Dataset df = spark.implicits().rddToDatasetHolder(sc.textFile(paths.mkString(","), sc.textFile$default$2()), spark.implicits().newStringEncoder()).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"docs"}));
        if (stopwordFile.isEmpty()) {
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        } else {
            String[] stopWordText = (String[])sc.textFile(stopwordFile, sc.textFile$default$2()).collect();
            stringArray = (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])stopWordText), (Function1 & Serializable)x$2 -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(x$2)).split("\\s+"), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class));
        }
        String[] customizedStopWords = stringArray;
        RegexTokenizer tokenizer = (RegexTokenizer)new RegexTokenizer().setInputCol("docs").setOutputCol("rawTokens");
        StopWordsRemover stopWordsRemover = new StopWordsRemover().setInputCol("rawTokens").setOutputCol("tokens");
        stopWordsRemover.setStopWords((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])stopWordsRemover.getStopWords()), (Object)customizedStopWords, ClassTag$.MODULE$.apply(String.class)));
        CountVectorizer countVectorizer = new CountVectorizer().setVocabSize(vocabSize).setInputCol("tokens").setOutputCol("features");
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{tokenizer, stopWordsRemover, countVectorizer}));
        PipelineModel model = pipeline.fit(df);
        RDD documents = model.transform(df).select("features", (scala.collection.immutable.Seq)Nil$.MODULE$).rdd().map((Function1 & Serializable)x0$1 -> {
            Object features;
            Some some;
            Row row = x0$1;
            if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(1) == 0 && (features = ((SeqOps)some.get()).apply(0)) instanceof org.apache.spark.ml.linalg.Vector) {
                org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)features;
                return Vectors$.MODULE$.fromML(vector);
            }
            throw new MatchError((Object)row);
        }, ClassTag$.MODULE$.apply(Vector.class)).zipWithIndex().map((Function1 & Serializable)x$3 -> x$3.swap(), ClassTag$.MODULE$.apply(Tuple2.class));
        return new Tuple3((Object)documents, (Object)((CountVectorizerModel)model.stages()[2]).vocabulary(), (Object)BoxesRunTime.boxToLong((long)((long)RDD$.MODULE$.numericRDDToDoubleRDDFunctions(documents.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)LDAExample$.$anonfun$preprocess$5(x$4)), (ClassTag)ClassTag$.MODULE$.Int()), (Numeric)Numeric.IntIsIntegral$.MODULE$).sum())));
    }

    public static final /* synthetic */ void $anonfun$run$4(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            String term = (String)tuple2._1();
            double weight = tuple2._2$mcD$sp();
            Predef$.MODULE$.println((Object)(term + "\t" + weight));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$run$3(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Tuple2[] topic = (Tuple2[])tuple2._1();
            int i = tuple2._2$mcI$sp();
            Predef$.MODULE$.println((Object)("TOPIC " + i));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])topic), (Function1 & Serializable)x0$4 -> {
                LDAExample$.$anonfun$run$4(x0$4);
                return BoxedUnit.UNIT;
            });
            Predef$.MODULE$.println();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$preprocess$5(Tuple2 x$4) {
        return ((Vector)x$4._2()).numActives();
    }

    private LDAExample$() {
    }
}

