/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanModifierUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PlanModifierUtil.class);

    protected static void fixTopOBSchema(RelNode rootRel, Pair<RelNode, RelNode> topSelparentPair, List<FieldSchema> resultSchema, boolean replaceProject) throws CalciteSemanticException {
        if (!(topSelparentPair.getKey() instanceof Sort) || !HiveCalciteUtil.orderRelNode((RelNode)topSelparentPair.getKey())) {
            return;
        }
        HiveSortLimit obRel = (HiveSortLimit)topSelparentPair.getKey();
        Project obChild = (Project)topSelparentPair.getValue();
        if (obChild.getRowType().getFieldCount() <= resultSchema.size()) {
            return;
        }
        RelDataType rt = obChild.getRowType();
        HashSet collationInputRefs = new HashSet(RelCollations.ordinals((RelCollation)obRel.getCollation()));
        ImmutableMap.Builder inputRefToCallMapBldr = ImmutableMap.builder();
        for (int i = resultSchema.size(); i < rt.getFieldCount(); ++i) {
            if (!collationInputRefs.contains(i)) continue;
            RexNode obyExpr = (RexNode)obChild.getChildExps().get(i);
            if (obyExpr instanceof RexCall) {
                LOG.debug("Old RexCall : " + obyExpr);
                obyExpr = PlanModifierUtil.adjustOBSchema((RexCall)obyExpr, obChild, resultSchema);
                LOG.debug("New RexCall : " + obyExpr);
            }
            inputRefToCallMapBldr.put((Object)i, (Object)obyExpr);
        }
        ImmutableMap inputRefToCallMap = inputRefToCallMapBldr.build();
        if (obChild.getRowType().getFieldCount() - inputRefToCallMap.size() != resultSchema.size()) {
            LOG.error(PlanModifierUtil.generateInvalidSchemaMessage(obChild, resultSchema, inputRefToCallMap.size()));
            throw new CalciteSemanticException("Result Schema didn't match Optimized Op Tree Schema");
        }
        if (replaceProject) {
            HiveProject replacementProjectRel = HiveProject.create(obChild.getInput(), obChild.getChildExps().subList(0, resultSchema.size()), obChild.getRowType().getFieldNames().subList(0, resultSchema.size()));
            obRel.replaceInput(0, replacementProjectRel);
        }
        obRel.setInputRefToCallMap((ImmutableMap<Integer, RexNode>)inputRefToCallMap);
    }

    private static RexCall adjustOBSchema(RexCall obyExpr, Project obChild, List<FieldSchema> resultSchema) {
        int a = -1;
        ArrayList<Object> operands = new ArrayList<Object>();
        for (int k = 0; k < obyExpr.operands.size(); ++k) {
            RexNode rn = (RexNode)obyExpr.operands.get(k);
            for (int j = 0; j < resultSchema.size(); ++j) {
                if (!((RexNode)obChild.getChildExps().get(j)).toString().equals(rn.toString())) continue;
                a = j;
                break;
            }
            if (a != -1) {
                operands.add(new RexInputRef(a, rn.getType()));
            } else if (rn instanceof RexCall) {
                operands.add(PlanModifierUtil.adjustOBSchema((RexCall)rn, obChild, resultSchema));
            } else {
                operands.add(rn);
            }
            a = -1;
        }
        return (RexCall)obChild.getCluster().getRexBuilder().makeCall(obyExpr.getType(), obyExpr.getOperator(), operands);
    }

    protected static String generateInvalidSchemaMessage(Project topLevelProj, List<FieldSchema> resultSchema, int fieldsForOB) {
        String errorDesc = "Result Schema didn't match Calcite Optimized Op Tree; schema: ";
        for (FieldSchema fs : resultSchema) {
            errorDesc = errorDesc + "[" + fs.getName() + ":" + fs.getType() + "], ";
        }
        errorDesc = errorDesc + " projection fields: ";
        for (RexNode exp : topLevelProj.getChildExps()) {
            errorDesc = errorDesc + "[" + exp.toString() + ":" + exp.getType() + "], ";
        }
        if (fieldsForOB != 0) {
            errorDesc = errorDesc + fieldsForOB + " fields removed due to ORDER BY  ";
        }
        return errorDesc.substring(0, errorDesc.length() - 2);
    }
}

