/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.reports;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.maven.mojos.reports.ReportContext;
import org.apache.sling.feature.maven.mojos.reports.Reporter;

public class ScriptsImportPackagesReporter
implements Reporter {
    private static final String PREFIX = "jcr_root/";

    @Override
    public String getName() {
        return "scripts-imported-packages";
    }

    @Override
    public void generateReport(ReportContext ctx) throws MojoExecutionException {
        TreeSet<ArtifactId> artifacts = new TreeSet<ArtifactId>();
        for (Feature feature : ctx.getFeatures()) {
            for (Extension ext : feature.getExtensions()) {
                if (ext.getType() != ExtensionType.ARTIFACTS || !"content-packages".equals(ext.getName())) continue;
                for (Artifact artifact : ext.getArtifacts()) {
                    if (!ctx.matches(artifact.getId())) continue;
                    artifacts.add(artifact.getId());
                }
            }
        }
        ArrayList<String> report = new ArrayList<String>();
        for (ArtifactId id : artifacts) {
            URL url = ctx.getArtifactProvider().provide(id);
            try (ZipInputStream zis = new ZipInputStream(url.openStream());){
                ZipEntry entry = null;
                while ((entry = zis.getNextEntry()) != null) {
                    String path;
                    if (!entry.getName().startsWith(PREFIX) || !(path = entry.getName().substring(PREFIX.length() - 1)).endsWith(".jsp")) continue;
                    Set<String> imports = this.getImports(zis);
                    for (String imp : imports) {
                        report.add(imp.concat("    ").concat(id.toMvnId()).concat("    ").concat(path));
                    }
                }
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Unable to read from " + id.toMvnId(), (Exception)ioe);
            }
        }
        ctx.addReport(this.getName().concat(".txt"), report);
    }

    private String readScript(ZipInputStream is) throws IOException {
        StringBuffer buf = new StringBuffer();
        byte[] buffer = new byte[8192];
        int l = 0;
        while ((l = is.read(buffer)) > 0) {
            buf.append(new String(buffer, 0, l, StandardCharsets.UTF_8));
        }
        return buf.toString();
    }

    private Set<String> getImports(ZipInputStream is) throws IOException {
        HashSet<String> imports = new HashSet<String>();
        String script = this.readScript(is);
        int start = 0;
        int sectionStart = -1;
        while (start < script.length()) {
            int pos;
            if (sectionStart != -1) {
                int importEnd;
                int importStart;
                int importPos;
                String page;
                pos = script.indexOf("%>", start);
                if (pos == -1) {
                    start = script.length();
                    continue;
                }
                start = pos + 2;
                String section = script.substring(sectionStart, pos);
                sectionStart = -1;
                int pagePos = section.indexOf("page");
                if (pagePos == -1 || !Character.isWhitespace((page = section.substring(pagePos + 4)).charAt(0)) || (importPos = page.indexOf("import")) == -1) continue;
                for (importStart = importPos + 6; importStart < page.length() && page.charAt(importStart) != '='; ++importStart) {
                }
                if (importStart >= page.length()) continue;
                ++importStart;
                while (importStart < page.length() && Character.isWhitespace(page.charAt(importStart))) {
                    ++importStart;
                }
                if (importStart >= page.length() || page.charAt(importStart) != '\"') continue;
                for (importEnd = ++importStart; importEnd < page.length() && page.charAt(importEnd) != '\"'; ++importEnd) {
                }
                if (importEnd >= page.length()) continue;
                String imp = page.substring(importStart, importEnd);
                StringTokenizer st = new StringTokenizer(imp, ",");
                while (st.hasMoreTokens()) {
                    String statement = st.nextToken().trim();
                    int lastDot = statement.lastIndexOf(46);
                    imports.add(lastDot == -1 ? statement : statement.substring(0, lastDot));
                }
                continue;
            }
            pos = script.indexOf("<%@", start);
            if (pos == -1) {
                start = script.length();
                continue;
            }
            start = sectionStart = start + 3;
        }
        return imports;
    }
}

