/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven;

import aQute.bnd.version.MavenVersion;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import org.codehaus.plexus.interpolation.ValueSource;

public class Substitution {
    public static String replaceMavenVars(MavenProject project, boolean legacyReplace, boolean replaceProjectProps, String[] additionalProperties, String s) {
        SimpleRecursionInterceptor recursionInterceptor;
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        if (legacyReplace) {
            project.getProperties().setProperty("project.osgiVersion", Substitution.getOSGiVersion(project.getVersion()));
            interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(System.getProperties()));
            interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(project.getProperties()));
            List<String> synonymPrefixes = Collections.singletonList("project.");
            PrefixedValueSourceWrapper modelWrapper = new PrefixedValueSourceWrapper((ValueSource)new ObjectBasedValueSource((Object)project), synonymPrefixes, true);
            interpolator.addValueSource((ValueSource)modelWrapper);
            recursionInterceptor = new PrefixAwareRecursionInterceptor(synonymPrefixes, true);
        } else {
            Properties props = new Properties();
            if (replaceProjectProps) {
                props.setProperty("project.groupId", project.getGroupId());
                props.setProperty("project.artifactId", project.getArtifactId());
                props.setProperty("project.version", project.getVersion());
                props.setProperty("project.osgiVersion", Substitution.getOSGiVersion(project.getVersion()));
            }
            if (additionalProperties != null) {
                for (String p : additionalProperties) {
                    String value = System.getProperty(p = p.trim());
                    if (value == null && project.getProperties().containsKey(p)) {
                        value = project.getProperties().getProperty(p);
                    }
                    if (value == null) continue;
                    props.setProperty(p, value);
                }
            }
            interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(props));
            recursionInterceptor = new SimpleRecursionInterceptor();
        }
        try {
            return interpolator.interpolate(s, (RecursionInterceptor)recursionInterceptor);
        }
        catch (InterpolationException e) {
            throw new RuntimeException("An error occurred while interpolating variables to JSON:\n" + s, e);
        }
    }

    private static String cleanVersionString(String version) {
        StringBuilder sb = new StringBuilder();
        boolean afterDot = false;
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c == '.') {
                if (afterDot) {
                    sb.append('0');
                }
                afterDot = true;
                sb.append(c);
                continue;
            }
            if (afterDot && c == '0') continue;
            if (afterDot && c == '-') {
                sb.append('0');
                sb.append(c);
                afterDot = false;
                continue;
            }
            afterDot = false;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getOSGiVersion(String version) {
        DefaultArtifactVersion dav = new DefaultArtifactVersion(Substitution.cleanVersionString(version));
        StringBuilder sb = new StringBuilder();
        sb.append(dav.getMajorVersion());
        sb.append('.');
        sb.append(dav.getMinorVersion());
        sb.append('.');
        sb.append(dav.getIncrementalVersion());
        if (dav.getQualifier() != null) {
            sb.append('.');
            sb.append(dav.getQualifier());
        }
        MavenVersion mavenVersion = new MavenVersion(sb.toString());
        return mavenVersion.getOSGiVersion().toString();
    }
}

