/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.helper;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class SearchPathProvider {
    private final BundleContext bundleContext;
    private volatile ServiceRegistration<SearchPathProvider> serviceRegistration;
    private volatile List<String> searchPaths;

    @Activate
    public SearchPathProvider(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            try {
                this.serviceRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.serviceRegistration = null;
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void bindResourceResolverFactory(ResourceResolverFactory factory) {
        if (this.searchPaths == null || !this.searchPaths.equals(factory.getSearchPath())) {
            this.searchPaths = factory.getSearchPath();
            Hashtable<String, String[]> props = new Hashtable<String, String[]>();
            ((Dictionary)props).put("paths", this.searchPaths.toArray(new String[this.searchPaths.size()]));
            if (this.serviceRegistration != null) {
                this.serviceRegistration.setProperties(props);
            } else {
                this.serviceRegistration = this.bundleContext.registerService(SearchPathProvider.class, (Object)this, props);
            }
        }
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory factory) {
    }

    public List<String> getSearchPaths() {
        return this.searchPaths;
    }
}

