/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.JakartaPostResponse;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.impl.operations.AbstractPostOperation;

public class CheckinOperation
extends AbstractPostOperation {
    @Override
    protected void doRun(SlingJakartaHttpServletRequest request, JakartaPostResponse response, List<Modification> changes) throws PersistenceException {
        try {
            Iterator<Resource> res = this.getApplyToResources(request);
            if (res == null) {
                Resource resource = request.getResource();
                Node node = (Node)resource.adaptTo(Node.class);
                if (node == null) {
                    response.setStatus(404, "Missing source " + String.valueOf(resource) + " for checkout");
                    return;
                }
                node.getSession().getWorkspace().getVersionManager().checkin(node.getPath());
                changes.add(Modification.onCheckin(resource.getPath()));
            } else {
                while (res.hasNext()) {
                    Resource resource = res.next();
                    Node node = (Node)resource.adaptTo(Node.class);
                    if (node == null) continue;
                    node.getSession().getWorkspace().getVersionManager().checkin(node.getPath());
                    changes.add(Modification.onCheckin(resource.getPath()));
                }
            }
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    @Override
    protected boolean isSkipCheckin(SlingJakartaHttpServletRequest request) {
        return false;
    }
}

