/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.apache.sling.resourceresolver.impl.mapping.MapEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MapEntryIterator
implements Iterator<MapEntry> {
    private String key;
    private MapEntry next;
    private MapEntry nextGlobal;
    private MapEntry nextSpecial;
    @NotNull
    private final Iterator<MapEntry> globalListIterator;
    @NotNull
    private Iterator<MapEntry> specialIterator = Collections.emptyIterator();
    @NotNull
    private final Function<String, Iterator<MapEntry>> getCurrentMapEntryIteratorForVanityPath;
    private final boolean vanityPathPrecedence;

    public MapEntryIterator(@Nullable String startKey, @NotNull List<MapEntry> globalList, @NotNull Function<String, Iterator<MapEntry>> getCurrentMapEntryIteratorForVanityPath, boolean vanityPathPrecedence) {
        this.key = startKey;
        this.globalListIterator = globalList.iterator();
        this.vanityPathPrecedence = vanityPathPrecedence;
        this.getCurrentMapEntryIteratorForVanityPath = getCurrentMapEntryIteratorForVanityPath;
        this.seek();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public MapEntry next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        MapEntry result = this.next;
        this.seek();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void seek() {
        if (this.nextGlobal == null && this.globalListIterator.hasNext()) {
            this.nextGlobal = this.globalListIterator.next();
        }
        if (this.nextSpecial == null) {
            if (!this.specialIterator.hasNext()) {
                this.specialIterator = Collections.emptyIterator();
            }
            while (!this.specialIterator.hasNext() && this.key != null) {
                this.key = MapEntryIterator.removeSelectorsAndExtension(this.key);
                this.specialIterator = MapEntryIterator.nullIteratorToEmpty(this.getCurrentMapEntryIteratorForVanityPath.apply(this.key));
                this.key = MapEntryIterator.getParent(this.key);
            }
            if (this.specialIterator.hasNext()) {
                this.nextSpecial = this.specialIterator.next();
            }
        }
        if (this.useNextGlobal()) {
            this.next = this.nextGlobal;
            this.nextGlobal = null;
        } else {
            this.next = this.nextSpecial;
            this.nextSpecial = null;
        }
    }

    private boolean useNextGlobal() {
        if (this.nextSpecial == null) {
            return true;
        }
        if (this.nextGlobal == null) {
            return false;
        }
        if (this.vanityPathPrecedence) {
            return false;
        }
        return this.nextGlobal.getPattern().length() >= this.nextSpecial.getPattern().length();
    }

    @Nullable
    private static String getParent(@NotNull String path) {
        int lastSlash;
        path = ((String)path).length() > 1 ? ((lastSlash = ((String)path).lastIndexOf(47)) == 0 ? null : ((String)path).substring(0, lastSlash)) : null;
        return path;
    }

    @NotNull
    private static String removeSelectorsAndExtension(@NotNull String value) {
        int lastSlashPos = value.lastIndexOf(47);
        int lastDotPos = value.indexOf(46, lastSlashPos);
        if (lastDotPos != -1) {
            value = value.substring(0, lastDotPos);
        }
        return value;
    }

    @NotNull
    static Iterator<MapEntry> nullIteratorToEmpty(@Nullable Iterator<MapEntry> it) {
        return it == null ? Collections.emptyIterator() : it;
    }
}

