/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.io.Closeable;
import javax.jcr.Session;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.HelperData;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResourceFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

class JcrProviderState
implements Closeable {
    private final Session session;
    private final BundleContext bundleContext;
    private final ServiceReference<SlingRepository> repositoryRef;
    private final boolean logout;
    private final JcrItemResourceFactory resourceFactory;
    private final HelperData helperData;

    JcrProviderState(@NotNull Session session, @NotNull HelperData helperData, boolean logout) {
        this(session, helperData, logout, null, null);
    }

    JcrProviderState(@NotNull Session session, @NotNull HelperData helperData, boolean logout, @Nullable BundleContext bundleContext, @Nullable ServiceReference<SlingRepository> repositoryRef) {
        this.session = session;
        this.bundleContext = bundleContext;
        this.repositoryRef = repositoryRef;
        this.logout = logout;
        this.helperData = helperData;
        this.resourceFactory = new JcrItemResourceFactory(session, helperData);
    }

    @NotNull
    Session getSession() {
        return this.session;
    }

    @NotNull
    JcrItemResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    @NotNull
    HelperData getHelperData() {
        return this.helperData;
    }

    @Override
    public void close() {
        this.logout();
    }

    void logout() {
        if (this.logout) {
            this.session.logout();
        }
        if (this.bundleContext != null) {
            try {
                this.bundleContext.ungetService(this.repositoryRef);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

