/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.net.URI;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.binary.BinaryDownload;
import org.apache.jackrabbit.api.binary.BinaryDownloadOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.external.URIProvider;
import org.apache.sling.jcr.resource.internal.NodeUtil;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={URIProvider.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@ServiceRanking(value=-100)
@Designate(ocd=Configuration.class)
public class BinaryDownloadUriProvider
implements URIProvider {
    private final boolean isContentDispositionAttachment;

    @Activate
    public BinaryDownloadUriProvider(Configuration configuration) {
        this(configuration.contentDisposition() == ContentDisposition.ATTACHMENT);
    }

    BinaryDownloadUriProvider(boolean isContentDispositionAttachment) {
        this.isContentDispositionAttachment = isContentDispositionAttachment;
    }

    @NotNull
    public URI toURI(@NotNull Resource resource, @NotNull URIProvider.Scope scope, @NotNull URIProvider.Operation operation) {
        if (!BinaryDownloadUriProvider.isRelevantScopeAndOperation(scope, operation)) {
            throw new IllegalArgumentException("This provider only provides URIs for 'READ' operations in scope 'PUBLIC' or 'EXTERNAL', but not for scope '" + scope + "' and operation '" + operation + "'");
        }
        Node node = (Node)resource.adaptTo(Node.class);
        if (node == null) {
            throw new IllegalArgumentException("This provider only provides URIs for node-based resources");
        }
        try {
            Property primaryProperty = this.getPrimaryProperty(node);
            try {
                return this.getUriFromProperty(resource, node, primaryProperty);
            }
            catch (RepositoryException e) {
                throw new IllegalArgumentException("Error getting URI for property '" + primaryProperty.getPath() + "'", e);
            }
        }
        catch (ItemNotFoundException e) {
            throw new IllegalArgumentException("Node does not have a primary property", e);
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException("Error accessing primary property", e);
        }
    }

    @NotNull
    protected Property getPrimaryProperty(@NotNull Node node) throws RepositoryException {
        return NodeUtil.getPrimaryProperty(node);
    }

    private static boolean isRelevantScopeAndOperation(@NotNull URIProvider.Scope scope, @NotNull URIProvider.Operation operation) {
        return (URIProvider.Scope.PUBLIC.equals((Object)scope) || URIProvider.Scope.EXTERNAL.equals((Object)scope)) && URIProvider.Operation.READ.equals((Object)operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private URI getUriFromProperty(@NotNull Resource resource, @NotNull Node node, @NotNull Property binaryProperty) throws RepositoryException {
        Binary binary = binaryProperty.getBinary();
        if (!(binary instanceof BinaryDownload)) {
            binary.dispose();
            throw new IllegalArgumentException("The property " + binaryProperty.getPath() + " is not backed by a blob store allowing direct HTTP access");
        }
        BinaryDownload binaryDownload = (BinaryDownload)BinaryDownload.class.cast(binary);
        try {
            String encoding = resource.getResourceMetadata().getCharacterEncoding();
            String fileName = node.getName();
            String mediaType = resource.getResourceMetadata().getContentType();
            BinaryDownloadOptions.BinaryDownloadOptionsBuilder optionsBuilder = BinaryDownloadOptions.builder().withFileName(fileName);
            if (encoding != null) {
                optionsBuilder.withCharacterEncoding(encoding);
            }
            if (mediaType != null) {
                optionsBuilder.withMediaType(mediaType);
            }
            if (this.isContentDispositionAttachment) {
                optionsBuilder.withDispositionTypeAttachment();
            } else {
                optionsBuilder.withDispositionTypeInline();
            }
            URI uri = binaryDownload.getURI(optionsBuilder.build());
            if (uri == null) {
                throw new IllegalArgumentException("Cannot provide url for downloading the binary property at '" + binaryProperty.getPath() + "'");
            }
            URI uRI = uri;
            return uRI;
        }
        finally {
            binaryDownload.dispose();
        }
    }

    @ObjectClassDefinition(name="Apache Sling Binary Download URI Provider", description="Provides URIs for resources containing a primary JCR binary property backed by a blob store allowing direct HTTP access")
    public static @interface Configuration {
        @AttributeDefinition(name="Content-Disposition", description="The content-disposition header to send when the binary is delivered via HTTP")
        public ContentDisposition contentDisposition();
    }

    static enum ContentDisposition {
        INLINE,
        ATTACHMENT;

    }
}

