/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.sling.installer.api.tasks.RegisteredResource;
import org.slf4j.Logger;

public class Util {
    public static void setField(Object obj, String name, Object value) throws IOException {
        try {
            Field field = obj.getClass().getDeclaredField(name);
            if (field == null) {
                throw new IOException("Field " + name + " not found in class " + obj.getClass());
            }
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (SecurityException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (NoSuchFieldException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (IllegalArgumentException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (IllegalAccessException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Manifest getManifest(RegisteredResource rsrc, Logger logger) throws IOException {
        InputStream ins = rsrc.getInputStream();
        Manifest result = null;
        if (ins != null) {
            JarInputStream jis = null;
            try {
                jis = new JarInputStream(ins);
                result = jis.getManifest();
                if (!rsrc.getURL().endsWith(".jar") || result != null) return result;
                logger.warn("Resource {} does not have the manifest as its first entry in the archive. If this is a bundle, make sure to put the manifest first in the jar file.", (Object)rsrc.getURL());
                return result;
            }
            finally {
                if (jis != null) {
                    try {
                        jis.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    try {
                        ins.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        logger.debug("Unable to get input stream from {}", (Object)rsrc);
        return result;
    }

    public static BundleHeaders readBundleHeaders(RegisteredResource resource, Logger logger) {
        try {
            Manifest m = Util.getManifest(resource, logger);
            if (m != null) {
                String sn = m.getMainAttributes().getValue("Bundle-SymbolicName");
                if (sn != null) {
                    String v = m.getMainAttributes().getValue("Bundle-Version");
                    if (v != null) {
                        int paramPos = sn.indexOf(59);
                        String symbolicName = paramPos == -1 ? sn : sn.substring(0, paramPos);
                        BundleHeaders headers = new BundleHeaders();
                        headers.symbolicName = symbolicName;
                        headers.version = v;
                        String actPolicy = m.getMainAttributes().getValue("Bundle-ActivationPolicy");
                        if ("lazy".equals(actPolicy)) {
                            headers.activationPolicy = actPolicy;
                        }
                        return headers;
                    }
                    logger.debug("Unable to get version from manifest : {}", (Object)resource);
                } else {
                    logger.debug("Unable to get symbolic name from manifest : {}", (Object)resource);
                }
            } else {
                logger.debug("Unable to read manifest from : {}", (Object)resource);
            }
        }
        catch (IOException ignore) {
            logger.debug("Exception occured during processing of " + resource, (Throwable)ignore);
        }
        return null;
    }

    public static final class BundleHeaders {
        public String symbolicName;
        public String version;
        public String activationPolicy;

        public String toString() {
            return "BundleHeaders [symbolicName=" + this.symbolicName + ", version=" + this.version + ", activationPolicy=" + this.activationPolicy + "]";
        }
    }
}

