/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.apache.felix.cm.impl.Log;
import org.apache.felix.cm.impl.persistence.ExtPersistenceManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ConfigurationAdminStarter {
    private final BundleContext bundleContext;
    private volatile ConfigurationManager configurationManager;
    private volatile ExtPersistenceManager persistenceManager;
    private final AtomicBoolean pluginsAvailable = new AtomicBoolean(false);
    private volatile String registeredConfigurationPlugins = "";
    private volatile ServiceTracker<Object, Object> coordinatorTracker;

    public ConfigurationAdminStarter(BundleContext bundleContext) throws BundleException, InvalidSyntaxException {
        this.bundleContext = bundleContext;
    }

    public void stop() {
        this.deactivate();
    }

    public void activate(ExtPersistenceManager pm) {
        try {
            this.configurationManager = new ConfigurationManager(pm, this.bundleContext);
            this.startCoordinatorTracker();
            ServiceReference<ConfigurationAdmin> ref = this.configurationManager.start();
            this.configurationManager.updateRegisteredConfigurationPlugins(this.registeredConfigurationPlugins);
            Log.logger.set(ref);
        }
        catch (IOException ioe) {
            Log.logger.log(1, "Failure setting up dynamic configuration bindings", ioe);
        }
    }

    public void deactivate() {
        this.stopCoordinatorTracker();
        if (this.configurationManager != null) {
            this.configurationManager.stop();
            this.configurationManager = null;
        }
        Log.logger.set(null);
    }

    private void startCoordinatorTracker() {
        this.coordinatorTracker = new ServiceTracker(this.bundleContext, "org.osgi.service.coordinator.Coordinator", (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Object>(){
            private final SortedMap<ServiceReference<Object>, Object> sortedServices = new TreeMap<ServiceReference<Object>, Object>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object addingService(ServiceReference<Object> reference) {
                Object srv = ConfigurationAdminStarter.this.bundleContext.getService(reference);
                if (srv != null) {
                    SortedMap<ServiceReference<Object>, Object> sortedMap = this.sortedServices;
                    synchronized (sortedMap) {
                        this.sortedServices.put(reference, srv);
                        ConfigurationAdminStarter.this.configurationManager.setCoordinator(this.sortedServices.get(this.sortedServices.lastKey()));
                    }
                }
                return srv;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifiedService(ServiceReference<Object> reference, Object srv) {
                SortedMap<ServiceReference<Object>, Object> sortedMap = this.sortedServices;
                synchronized (sortedMap) {
                    this.sortedServices.remove(reference);
                    this.sortedServices.put(reference, srv);
                    ConfigurationAdminStarter.this.configurationManager.setCoordinator(this.sortedServices.get(this.sortedServices.lastKey()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference<Object> reference, Object service) {
                SortedMap<ServiceReference<Object>, Object> sortedMap = this.sortedServices;
                synchronized (sortedMap) {
                    this.sortedServices.remove(reference);
                    if (this.sortedServices.isEmpty()) {
                        ConfigurationAdminStarter.this.configurationManager.setCoordinator(null);
                    } else {
                        ConfigurationAdminStarter.this.configurationManager.setCoordinator(this.sortedServices.get(this.sortedServices.lastKey()));
                    }
                }
                ConfigurationAdminStarter.this.bundleContext.ungetService(reference);
            }
        });
        this.coordinatorTracker.open();
    }

    private void stopCoordinatorTracker() {
        if (this.coordinatorTracker != null) {
            this.coordinatorTracker.close();
            this.coordinatorTracker = null;
        }
    }

    public void unsetPersistenceManager() {
        this.persistenceManager = null;
        this.deactivate();
    }

    public void setPersistenceManager(ExtPersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
        this.checkStart();
    }

    public void updatePluginsSet(boolean value) {
        if (this.pluginsAvailable.compareAndSet(!value, value)) {
            if (!value) {
                this.deactivate();
            } else {
                this.checkStart();
            }
        }
    }

    public void checkStart() {
        if (this.pluginsAvailable.get() && this.persistenceManager != null) {
            this.activate(this.persistenceManager);
        }
    }

    public void updateRegisteredConfigurationPlugins(String propValue) {
        this.registeredConfigurationPlugins = propValue;
        ConfigurationManager localCM = this.configurationManager;
        if (localCM != null) {
            localCM.updateRegisteredConfigurationPlugins(propValue);
        }
    }
}

