/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.nodetype;

import javax.jcr.PropertyType;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.jackrabbit.commons.query.qom.Operator;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.nodetype.AbstractItemDefinitionTemplate;

class PropertyDefinitionTemplateImpl
extends AbstractItemDefinitionTemplate
implements PropertyDefinitionTemplate {
    private int type;
    private String[] constraints;
    private Value[] defaultValues;
    private boolean multiple;
    private boolean fullTextSearchable;
    private boolean queryOrderable;
    private String[] queryOperators;

    PropertyDefinitionTemplateImpl(NamePathResolver resolver) {
        super(resolver);
        this.type = 1;
        this.fullTextSearchable = true;
        this.queryOrderable = true;
        this.queryOperators = Operator.getAllQueryOperators();
    }

    PropertyDefinitionTemplateImpl(PropertyDefinition def, NamePathResolver resolver) throws ConstraintViolationException {
        super((ItemDefinition)def, resolver);
        this.type = def.getRequiredType();
        this.defaultValues = def.getDefaultValues();
        this.multiple = def.isMultiple();
        this.fullTextSearchable = def.isFullTextSearchable();
        this.queryOrderable = def.isQueryOrderable();
        this.queryOperators = def.getAvailableQueryOperators();
        this.setValueConstraints(def.getValueConstraints());
    }

    public void setRequiredType(int type) {
        PropertyType.nameFromValue((int)type);
        this.type = type;
    }

    public void setValueConstraints(String[] constraints) {
        this.constraints = constraints;
    }

    public void setDefaultValues(Value[] defaultValues) {
        this.defaultValues = defaultValues;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setAvailableQueryOperators(String[] operators) {
        this.queryOperators = operators;
    }

    public void setFullTextSearchable(boolean searchable) {
        this.fullTextSearchable = searchable;
    }

    public void setQueryOrderable(boolean orderable) {
        this.queryOrderable = orderable;
    }

    public int getRequiredType() {
        return this.type;
    }

    public String[] getValueConstraints() {
        return this.constraints;
    }

    public Value[] getDefaultValues() {
        return this.defaultValues;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public String[] getAvailableQueryOperators() {
        return this.queryOperators;
    }

    public boolean isFullTextSearchable() {
        return this.fullTextSearchable;
    }

    public boolean isQueryOrderable() {
        return this.queryOrderable;
    }
}

