/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.state.AbstractItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateCreationListener;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.state.TransientItemStateFactory;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransientISFactory
extends AbstractItemStateFactory
implements TransientItemStateFactory,
ItemStateCreationListener {
    private static Logger log = LoggerFactory.getLogger(TransientISFactory.class);
    private final ItemStateFactory workspaceStateFactory;
    private final ItemDefinitionProvider defProvider;

    public TransientISFactory(AbstractItemStateFactory workspaceStateFactory, ItemDefinitionProvider defProvider) {
        this.workspaceStateFactory = workspaceStateFactory;
        this.defProvider = defProvider;
        workspaceStateFactory.addCreationListener(this);
    }

    @Override
    public NodeState createNewNodeState(NodeEntry entry, Name nodetypeName, QNodeDefinition definition) {
        NodeState nodeState = new NodeState(entry, nodetypeName, Name.EMPTY_ARRAY, this, definition, this.defProvider);
        this.notifyCreated(nodeState);
        return nodeState;
    }

    @Override
    public PropertyState createNewPropertyState(PropertyEntry entry, QPropertyDefinition definition, QValue[] values, int propertyType) throws RepositoryException {
        PropertyState propState = new PropertyState(entry, this, definition, this.defProvider, values, propertyType);
        this.notifyCreated(propState);
        return propState;
    }

    @Override
    public NodeState createRootState(NodeEntry entry) throws ItemNotFoundException, RepositoryException {
        NodeState state = this.workspaceStateFactory.createRootState(entry);
        return state;
    }

    @Override
    public NodeState createNodeState(NodeId nodeId, NodeEntry entry) throws ItemNotFoundException, RepositoryException {
        NodeState state = this.workspaceStateFactory.createNodeState(nodeId, entry);
        return state;
    }

    @Override
    public NodeState createDeepNodeState(NodeId nodeId, NodeEntry anyParent) throws ItemNotFoundException, RepositoryException {
        NodeState state = this.workspaceStateFactory.createDeepNodeState(nodeId, anyParent);
        return state;
    }

    @Override
    public PropertyState createPropertyState(PropertyId propertyId, PropertyEntry entry) throws ItemNotFoundException, RepositoryException {
        PropertyState state = this.workspaceStateFactory.createPropertyState(propertyId, entry);
        return state;
    }

    @Override
    public PropertyState createDeepPropertyState(PropertyId propertyId, NodeEntry anyParent) throws ItemNotFoundException, RepositoryException {
        PropertyState state = this.workspaceStateFactory.createDeepPropertyState(propertyId, anyParent);
        return state;
    }

    @Override
    public Iterator<ChildInfo> getChildNodeInfos(NodeId nodeId) throws ItemNotFoundException, RepositoryException {
        return this.workspaceStateFactory.getChildNodeInfos(nodeId);
    }

    @Override
    public Iterator<PropertyId> getNodeReferences(NodeState nodeState, Name propertyName, boolean weak) {
        if (nodeState.getStatus() == 4) {
            Set t = Collections.emptySet();
            return t.iterator();
        }
        return this.workspaceStateFactory.getNodeReferences(nodeState, propertyName, weak);
    }

    @Override
    public void created(ItemState state) {
        log.debug("ItemState created by WorkspaceItemStateFactory");
        this.notifyCreated(state);
    }

    @Override
    public void statusChanged(ItemState state, int previousStatus) {
    }
}

