/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers.slinginitialcontent;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.AssemblerProvider;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.BundleSlingInitialContentExtractContext;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.BundleSlingInitialContentJarEntryExtractor;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.ContentReaderProvider;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.ParentFolderRepoInitHandler;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.SlingInitialContentBundleEntryMetaData;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.SlingInitialContentBundleEntryMetaDataCollector;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Version;

public class BundleSlingInitialContentExtractor {
    protected final AssemblerProvider assemblerProvider = new AssemblerProvider();
    protected final ContentReaderProvider contentReaderProvider = new ContentReaderProvider();
    protected final ParentFolderRepoInitHandler parentFolderRepoInitHandler = new ParentFolderRepoInitHandler();

    @Nullable
    public InputStream extract(@NotNull BundleSlingInitialContentExtractContext context) throws IOException, ConverterException {
        ContentPackage2FeatureModelConverter contentPackage2FeatureModelConverter = context.getConverter();
        if (context.getSlingInitialContentPolicy() == ContentPackage2FeatureModelConverter.SlingInitialContentPolicy.KEEP) {
            return null;
        }
        if (CollectionUtils.isEmpty(context.getPathEntryList())) {
            return null;
        }
        Path strippedBundleFile = this.getNewBundleFile(context, contentPackage2FeatureModelConverter);
        SlingInitialContentBundleEntryMetaDataCollector collector = new SlingInitialContentBundleEntryMetaDataCollector(context, contentPackage2FeatureModelConverter, strippedBundleFile);
        Set<SlingInitialContentBundleEntryMetaData> collectedSlingInitialContentBundleEntries = collector.collectFromContextAndWriteTmpFiles();
        BundleSlingInitialContentJarEntryExtractor jarEntryExtractor = new BundleSlingInitialContentJarEntryExtractor(this.assemblerProvider, this.contentReaderProvider, this.parentFolderRepoInitHandler);
        for (SlingInitialContentBundleEntryMetaData slingInitialContentBundleEntryMetaData : collectedSlingInitialContentBundleEntries) {
            jarEntryExtractor.extractAndAddToAssembler(context, slingInitialContentBundleEntryMetaData, collectedSlingInitialContentBundleEntries);
        }
        this.finalizePackageAssembly(context);
        return Files.newInputStream(strippedBundleFile, StandardOpenOption.READ, StandardOpenOption.DELETE_ON_CLOSE);
    }

    static Version getModifiedOsgiVersion(@NotNull Version originalVersion) {
        return new Version(originalVersion.getMajor(), originalVersion.getMinor(), originalVersion.getMicro(), originalVersion.getQualifier() + "_" + "cp2fm-converted");
    }

    public void reset() {
        this.parentFolderRepoInitHandler.reset();
    }

    public void addRepoInitExtension(@NotNull List<VaultPackageAssembler> assemblers, @NotNull FeaturesManager featureManager) throws IOException, ConverterException {
        this.parentFolderRepoInitHandler.addRepoinitExtension(assemblers, featureManager);
    }

    protected void finalizePackageAssembly(@NotNull BundleSlingInitialContentExtractContext context) throws IOException, ConverterException {
        for (Map.Entry<PackageType, VaultPackageAssembler> entry : this.assemblerProvider.getPackageAssemblerEntrySet()) {
            File packageFile = entry.getValue().createPackage();
            ContentPackage2FeatureModelConverter converter = context.getConverter();
            converter.processSubPackage(context.getPath() + "-" + entry.getKey(), context.getRunMode(), converter.open(packageFile), false);
        }
        this.assemblerProvider.clear();
    }

    private Path getNewBundleFile(@NotNull BundleSlingInitialContentExtractContext context, ContentPackage2FeatureModelConverter contentPackage2FeatureModelConverter) throws IOException {
        Manifest manifest = context.getManifest();
        manifest.getMainAttributes().remove(new Attributes.Name("Sling-Initial-Content"));
        Version originalVersion = new Version(Objects.requireNonNull(manifest.getMainAttributes().getValue("Bundle-Version")));
        manifest.getMainAttributes().putValue("Bundle-Version", BundleSlingInitialContentExtractor.getModifiedOsgiVersion(originalVersion).toString());
        return Files.createTempFile(contentPackage2FeatureModelConverter.getTempDirectory().toPath(), "newBundle", ".jar", new FileAttribute[0]);
    }
}

