/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.extension.apiregions.api.ApiExport;

public class ApiRegion {
    public static final String GLOBAL = "global";
    private final List<ApiExport> exports = new ArrayList<ApiExport>();
    private final List<ArtifactId> origins = new ArrayList<ArtifactId>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final String name;
    private ApiRegion parent;

    public ApiRegion(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ArtifactId[] getFeatureOrigins() {
        return this.origins.toArray(new ArtifactId[0]);
    }

    public void setFeatureOrigins(ArtifactId ... featureOrigins) {
        this.origins.clear();
        if (featureOrigins != null) {
            this.origins.addAll(Stream.of(featureOrigins).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        }
    }

    public boolean add(ApiExport export) {
        boolean found = false;
        for (ApiExport c : this.exports) {
            if (!c.getName().equals(export.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.exports.add(export);
        }
        return !found;
    }

    public boolean remove(ApiExport export) {
        return this.exports.remove(export);
    }

    public boolean isEmpty() {
        return this.exports.isEmpty();
    }

    public Collection<ApiExport> listExports() {
        return Collections.unmodifiableCollection(this.exports);
    }

    public Collection<ApiExport> listAllExports() {
        ArrayList<ApiExport> list = new ArrayList<ApiExport>();
        if (this.parent != null) {
            list.addAll(this.parent.listAllExports());
        }
        list.addAll(this.exports);
        return Collections.unmodifiableCollection(list);
    }

    public ApiExport getExportByName(String name) {
        for (ApiExport e : this.exports) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public ApiExport getAllExportByName(String name) {
        for (ApiExport e : this.listAllExports()) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public ApiRegion getParent() {
        return this.parent;
    }

    void setParent(ApiRegion region) {
        this.parent = region;
    }

    public String toString() {
        return "ApiRegion [exports=" + this.exports + ", properties=" + this.properties + ", name=" + this.name + ", feature-origins=" + this.origins + "]";
    }

    public int hashCode() {
        return Objects.hash(this.exports, this.name, this.origins, this.parent, this.properties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiRegion other = (ApiRegion)obj;
        return Objects.equals(this.exports, other.exports) && Objects.equals(this.name, other.name) && Objects.equals(this.origins, other.origins) && Objects.equals(this.parent, other.parent) && Objects.equals(this.properties, other.properties);
    }
}

