/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.analyser;

import java.util.Map;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationApi;
import org.apache.sling.feature.extension.apiregions.api.config.validation.ConfigurationValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.FeatureValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.FeatureValidator;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidationResult;

public class CheckConfigurationApi
implements AnalyserTask {
    public String getId() {
        return "configuration-api";
    }

    public String getName() {
        return "Configuration API analyser task";
    }

    public void execute(AnalyserTaskContext context) throws Exception {
        FeatureValidator validator = new FeatureValidator();
        validator.setFeatureProvider(context.getFeatureProvider());
        ConfigurationApi api = ConfigurationApi.getConfigurationApi(context.getFeature());
        if (api == null) {
            context.reportExtensionWarning("configuration-api", "Configuration api is not specified, unable to validate feature");
        } else {
            FeatureValidationResult result = validator.validate(context.getFeature(), api);
            for (Map.Entry<String, PropertyValidationResult> entry : result.getFrameworkPropertyResults().entrySet()) {
                for (String string : entry.getValue().getWarnings()) {
                    context.reportWarning("Framework property " + entry.getKey() + " : " + string);
                }
                if (entry.getValue().isValid()) continue;
                for (String string : entry.getValue().getErrors()) {
                    context.reportError("Framework property " + entry.getKey() + " : " + string);
                }
            }
            for (Map.Entry<String, Object> entry : result.getConfigurationResults().entrySet()) {
                for (String string : ((ConfigurationValidationResult)entry.getValue()).getWarnings()) {
                    context.reportConfigurationWarning(context.getFeature().getConfigurations().getConfiguration(entry.getKey()), string);
                }
                for (Map.Entry entry2 : ((ConfigurationValidationResult)entry.getValue()).getPropertyResults().entrySet()) {
                    for (String warn : ((PropertyValidationResult)entry2.getValue()).getWarnings()) {
                        context.reportConfigurationWarning(context.getFeature().getConfigurations().getConfiguration(entry.getKey()), "Property ".concat((String)entry2.getKey()).concat(" - ").concat(warn));
                    }
                }
                if (((ConfigurationValidationResult)entry.getValue()).isValid()) continue;
                for (String string : ((ConfigurationValidationResult)entry.getValue()).getErrors()) {
                    context.reportConfigurationError(context.getFeature().getConfigurations().getConfiguration(entry.getKey()), string);
                }
                for (Map.Entry entry3 : ((ConfigurationValidationResult)entry.getValue()).getPropertyResults().entrySet()) {
                    if (((PropertyValidationResult)entry3.getValue()).isValid()) continue;
                    for (String err : ((PropertyValidationResult)entry3.getValue()).getErrors()) {
                        context.reportConfigurationError(context.getFeature().getConfigurations().getConfiguration(entry.getKey()), "Property ".concat((String)entry3.getKey()).concat(" - ").concat(err));
                    }
                }
            }
        }
    }
}

