/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media;

import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public enum MediaFileType {
    JPEG(new String[]{"image/jpeg"}, new String[]{"jpg", "jpeg"}),
    PNG(new String[]{"image/png"}, new String[]{"png"}),
    GIF(new String[]{"image/gif"}, new String[]{"gif"}),
    TIFF(new String[]{"image/tiff"}, new String[]{"tif", "tiff"}),
    SVG(new String[]{"image/svg+xml"}, new String[]{"svg"}),
    SWF(new String[]{"application/x-shockwave-flash"}, new String[]{"swf"});

    private final Set<String> contentTypes;
    private final Set<String> extensions;
    private static final EnumSet<MediaFileType> IMAGE_FILE_TYPES;
    private static final EnumSet<MediaFileType> BROWSER_IMAGE_FILE_TYPES;
    private static final EnumSet<MediaFileType> VECTOR_IMAGE_FILE_TYPES;
    private static final EnumSet<MediaFileType> FLASH_FILE_TYPES;

    private MediaFileType(String[] contentTypes, String[] extensions) {
        this.contentTypes = ImmutableSet.copyOf((Object[])contentTypes);
        this.extensions = ImmutableSet.copyOf((Object[])extensions);
    }

    public Set<String> getContentTypes() {
        return this.contentTypes;
    }

    public Set<String> getExtensions() {
        return this.extensions;
    }

    public static boolean isImage(@Nullable String fileExtension) {
        return MediaFileType.isExtension(IMAGE_FILE_TYPES, fileExtension);
    }

    @NotNull
    public static Set<String> getImageFileExtensions() {
        return MediaFileType.getFileExtensions(IMAGE_FILE_TYPES);
    }

    @NotNull
    public static Set<String> getImageContentTypes() {
        return MediaFileType.getContentTypes(IMAGE_FILE_TYPES);
    }

    public static boolean isBrowserImage(@Nullable String fileExtension) {
        return MediaFileType.isExtension(BROWSER_IMAGE_FILE_TYPES, fileExtension);
    }

    @NotNull
    public static Set<String> getBrowserImageFileExtensions() {
        return MediaFileType.getFileExtensions(BROWSER_IMAGE_FILE_TYPES);
    }

    @NotNull
    public static Set<String> getBrowserImageContentTypes() {
        return MediaFileType.getContentTypes(BROWSER_IMAGE_FILE_TYPES);
    }

    public static boolean isVectorImage(@Nullable String fileExtension) {
        return MediaFileType.isExtension(VECTOR_IMAGE_FILE_TYPES, fileExtension);
    }

    @NotNull
    public static Set<String> getVectorImageFileExtensions() {
        return MediaFileType.getFileExtensions(VECTOR_IMAGE_FILE_TYPES);
    }

    @NotNull
    public static Set<String> getVectorImageContentTypes() {
        return MediaFileType.getContentTypes(VECTOR_IMAGE_FILE_TYPES);
    }

    @Deprecated
    public static boolean isFlash(@Nullable String fileExtension) {
        return MediaFileType.isExtension(FLASH_FILE_TYPES, fileExtension);
    }

    @Deprecated
    @NotNull
    public static Set<String> getFlashFileExtensions() {
        return MediaFileType.getFileExtensions(FLASH_FILE_TYPES);
    }

    @Deprecated
    @NotNull
    public static Set<String> getFlashContentTypes() {
        return MediaFileType.getContentTypes(FLASH_FILE_TYPES);
    }

    private static Set<String> getContentTypes(@NotNull EnumSet<MediaFileType> fileTypes) {
        return fileTypes.stream().flatMap(type -> type.getContentTypes().stream()).collect(Collectors.toSet());
    }

    private static boolean isExtension(@NotNull EnumSet<MediaFileType> fileTypes, @Nullable String fileExtension) {
        if (StringUtils.isEmpty((CharSequence)fileExtension)) {
            return false;
        }
        return fileTypes.stream().filter(type -> type.getExtensions().contains(StringUtils.lowerCase((String)fileExtension))).findFirst().isPresent();
    }

    private static Set<String> getFileExtensions(@NotNull EnumSet<MediaFileType> fileTypes) {
        return fileTypes.stream().flatMap(type -> type.getExtensions().stream()).collect(Collectors.toSet());
    }

    static {
        IMAGE_FILE_TYPES = EnumSet.of(GIF, JPEG, PNG, TIFF, SVG);
        BROWSER_IMAGE_FILE_TYPES = EnumSet.of(GIF, JPEG, PNG, SVG);
        VECTOR_IMAGE_FILE_TYPES = EnumSet.of(SVG);
        FLASH_FILE_TYPES = EnumSet.of(SWF);
    }
}

