/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.osgi;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Named;
import org.ops4j.peaberry.Peaberry;
import org.ops4j.peaberry.ServiceUnavailableException;
import org.ops4j.peaberry.cache.AbstractServiceImport;
import org.ops4j.peaberry.cache.CachingServiceRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class Activator
implements BundleActivator {
    private static final String CACHE_INTERVAL_DEFAULT = "60000";
    private static final String CACHE_GENERATIONS_DEFAULT = "3";
    private Thread cleanupThread;

    public void start(final BundleContext context) {
        Injector injector = Guice.createInjector((Module[])new Module[]{Peaberry.osgiModule(context), new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"org.ops4j.peaberry.cache.interval")).to(this.osgiProperty("org.ops4j.peaberry.cache.interval", Activator.CACHE_INTERVAL_DEFAULT));
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"org.ops4j.peaberry.cache.generations")).to(this.osgiProperty("org.ops4j.peaberry.cache.generations", Activator.CACHE_GENERATIONS_DEFAULT));
                this.bind((TypeLiteral)new TypeLiteral<Iterable<CachingServiceRegistry>>(){}).toProvider(Peaberry.service(CachingServiceRegistry.class).multiple());
            }

            private String osgiProperty(String name, String defaultValue) {
                String value = context.getProperty(name);
                return null == value ? defaultValue : value;
            }
        }});
        if ((Integer)injector.getInstance(Key.get(Integer.TYPE, (Annotation)Names.named((String)"org.ops4j.peaberry.cache.interval"))) >= 0) {
            this.cleanupThread = new Thread((Runnable)injector.getInstance(ImportManager.class), "Peaberry [cleanup]");
            this.cleanupThread.setPriority(1);
            this.cleanupThread.setDaemon(true);
            this.cleanupThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext ctx) throws InterruptedException {
        if (null != this.cleanupThread) {
            this.cleanupThread.interrupt();
            try {
                this.cleanupThread.join();
            }
            finally {
                this.cleanupThread = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportManager
    implements Runnable {
        private final Bundle bundle;
        private final int interval;
        private final int generations;
        private final Iterable<CachingServiceRegistry> registries;

        @Inject
        public ImportManager(BundleContext context, @Named(value="org.ops4j.peaberry.cache.interval") int interval, @Named(value="org.ops4j.peaberry.cache.generations") int generations, Iterable<CachingServiceRegistry> registries) {
            this.bundle = context.getBundle();
            this.interval = Math.max(100, interval);
            this.generations = Math.max(1, generations);
            this.registries = registries;
        }

        @Override
        public final void run() {
            int gen = 0;
            do {
                AbstractServiceImport.setCacheGeneration(gen);
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                gen = (gen + 1) % this.generations;
                for (CachingServiceRegistry i : this.registries) {
                    try {
                        i.flush(gen);
                    }
                    catch (ServiceUnavailableException e) {}
                }
            } while ((this.bundle.getState() & 0x28) != 0);
        }
    }
}

