/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.ServiceUnavailableException;
import org.ops4j.peaberry.internal.ClassWriter;
import org.ops4j.peaberry.internal.Label;
import org.ops4j.peaberry.internal.MethodVisitor;
import org.ops4j.peaberry.internal.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImportGlue {
    private static final String UNAVAILABLE_NAME = Type.getInternalName(ServiceUnavailableException.class);
    private static final String EXCEPTION_NAME = Type.getInternalName(Exception.class);
    private static final String IMPORT_NAME = Type.getInternalName(Import.class);
    private static final String OBJECT_NAME = Type.getInternalName(Object.class);
    private static final String VOID_DESC = "()V";
    private static final String IMPORT_DESC = Type.getDescriptor(Import.class);
    private static final String OBJECT_DESC = Type.getDescriptor(Object.class);
    private static final Method[] OBJECT_METHODS = Object.class.getMethods();
    private static final String PROXY_SUFFIX = "$pbryglu";
    private static final String PROXY_HANDLE = "__pbry__";

    private ImportGlue() {
    }

    static String getProxyName(String clazzName) {
        StringBuilder tmpName = new StringBuilder();
        if (clazzName.startsWith("java.") || clazzName.startsWith("java/")) {
            tmpName.append('$');
        }
        return tmpName.append(clazzName).append(PROXY_SUFFIX).toString();
    }

    static String getClazzName(String proxyName) {
        int head = '$' == proxyName.charAt(0) ? 1 : 0;
        int tail = proxyName.lastIndexOf(PROXY_SUFFIX);
        if (tail > 0) {
            return proxyName.substring(head, tail);
        }
        return proxyName;
    }

    static byte[] generateProxy(Class<?> clazz) {
        String[] interfaceNames;
        String superName;
        String clazzName = Type.getInternalName(clazz);
        String proxyName = ImportGlue.getProxyName(clazzName);
        if (clazz.isInterface()) {
            superName = OBJECT_NAME;
            interfaceNames = new String[]{clazzName};
        } else {
            superName = clazzName;
            interfaceNames = ImportGlue.getInternalNames(clazz.getInterfaces());
        }
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 17, proxyName, null, superName, interfaceNames);
        ImportGlue.init(cw, superName, proxyName);
        Method[] publicAPI = clazz.getMethods();
        ArrayList<Method> methods = new ArrayList<Method>(publicAPI.length + OBJECT_METHODS.length);
        Collections.addAll(methods, publicAPI);
        if (clazz.isInterface()) {
            for (Method m : OBJECT_METHODS) {
                if (!ImportGlue.missingMethod(publicAPI, m)) continue;
                methods.add(m);
            }
        }
        for (Method m : methods) {
            if ((m.getModifiers() & 0x18) != 0) continue;
            ImportGlue.wrap(cw, proxyName, m);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static void init(ClassWriter cw, String superName, String proxyName) {
        cw.visitField(18, PROXY_HANDLE, IMPORT_DESC, null, null).visitEnd();
        MethodVisitor v = cw.visitMethod(1, "<init>", '(' + IMPORT_DESC + ")V", null, null);
        v.visitCode();
        v.visitVarInsn(25, 0);
        v.visitInsn(89);
        v.visitVarInsn(25, 1);
        v.visitFieldInsn(181, proxyName, PROXY_HANDLE, IMPORT_DESC);
        v.visitMethodInsn(183, superName, "<init>", VOID_DESC);
        v.visitInsn(177);
        v.visitMaxs(0, 0);
        v.visitEnd();
    }

    private static void wrap(ClassWriter cw, String proxyName, Method method) {
        String methodName = method.getName();
        String descriptor = Type.getMethodDescriptor(method);
        String[] exceptions = ImportGlue.getInternalNames(method.getExceptionTypes());
        int modifiers = method.getModifiers() & 0xFFFFFADF;
        MethodVisitor v = cw.visitMethod(modifiers, methodName, descriptor, null, exceptions);
        Label start = new Label();
        Label invoke = new Label();
        Label end = new Label();
        Label ungetR = new Label();
        Label finalR = new Label();
        Label catchX = new Label();
        Label ungetX = new Label();
        Label finalX = new Label();
        v.visitCode();
        v.visitTryCatchBlock(start, ungetR, catchX, null);
        v.visitTryCatchBlock(ungetR, finalR, finalR, EXCEPTION_NAME);
        v.visitTryCatchBlock(ungetX, finalX, finalX, EXCEPTION_NAME);
        v.visitVarInsn(25, 0);
        v.visitFieldInsn(180, proxyName, PROXY_HANDLE, IMPORT_DESC);
        v.visitInsn(89);
        v.visitVarInsn(58, 0);
        v.visitLabel(start);
        v.visitMethodInsn(185, IMPORT_NAME, "get", "()" + OBJECT_DESC);
        v.visitInsn(89);
        v.visitJumpInsn(199, invoke);
        v.visitTypeInsn(187, UNAVAILABLE_NAME);
        v.visitInsn(89);
        v.visitMethodInsn(183, UNAVAILABLE_NAME, "<init>", VOID_DESC);
        v.visitInsn(191);
        v.visitLabel(invoke);
        Class<?> clazz = method.getDeclaringClass();
        String subjectName = Type.getInternalName(clazz);
        if (!clazz.isInterface()) {
            v.visitTypeInsn(192, subjectName);
        }
        int i = 1;
        for (Type t : Type.getArgumentTypes(method)) {
            v.visitVarInsn(t.getOpcode(21), i);
            i += t.getSize();
        }
        if (clazz.isInterface()) {
            v.visitMethodInsn(185, subjectName, methodName, descriptor);
        } else {
            v.visitMethodInsn(182, subjectName, methodName, descriptor);
        }
        Type returnType = Type.getReturnType(method);
        if (0 != returnType.getSort()) {
            v.visitVarInsn(returnType.getOpcode(54), 1);
        }
        v.visitLabel(ungetR);
        v.visitVarInsn(25, 0);
        v.visitMethodInsn(185, IMPORT_NAME, "unget", VOID_DESC);
        v.visitInsn(1);
        v.visitLabel(finalR);
        if (0 != returnType.getSort()) {
            v.visitVarInsn(returnType.getOpcode(21), 1);
        }
        v.visitInsn(returnType.getOpcode(172));
        v.visitLabel(catchX);
        v.visitVarInsn(58, 1);
        v.visitLabel(ungetX);
        v.visitVarInsn(25, 0);
        v.visitMethodInsn(185, IMPORT_NAME, "unget", VOID_DESC);
        v.visitInsn(1);
        v.visitLabel(finalX);
        v.visitVarInsn(25, 1);
        v.visitInsn(191);
        v.visitLabel(end);
        v.visitMaxs(0, 0);
        v.visitEnd();
    }

    private static String[] getInternalNames(Class<?> ... clazzes) {
        String[] names = new String[clazzes.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = Type.getInternalName(clazzes[i]);
        }
        return names;
    }

    private static boolean missingMethod(Method[] methods, Method method) {
        String sig = Arrays.toString(method.getParameterTypes());
        String name = method.getName();
        for (Method m : methods) {
            if (!name.equals(m.getName()) || !sig.equals(Arrays.toString(m.getParameterTypes()))) continue;
            return false;
        }
        return true;
    }
}

