/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.stats;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.event.impl.jobs.stats.BaseStatisticsImpl;
import org.apache.sling.event.jobs.Statistics;

public class StatisticsImpl
extends BaseStatisticsImpl
implements Statistics {
    private final AtomicLong startTime = new AtomicLong();
    private final AtomicLong activeJobs = new AtomicLong();
    private final AtomicLong queuedJobs = new AtomicLong();

    public StatisticsImpl() {
        this(System.currentTimeMillis());
    }

    public StatisticsImpl(long startTime) {
        this.startTime.set(startTime);
    }

    @Override
    public long getStartTime() {
        return this.startTime.get();
    }

    @Override
    public long getNumberOfActiveJobs() {
        return this.activeJobs.get();
    }

    @Override
    public long getNumberOfQueuedJobs() {
        return this.queuedJobs.get();
    }

    @Override
    public long getNumberOfJobs() {
        return this.activeJobs.get() + this.queuedJobs.get();
    }

    @Override
    public synchronized void finishedJob(long jobTime) {
        super.finishedJob(jobTime);
        this.activeJobs.decrementAndGet();
    }

    @Override
    public synchronized void failedJob() {
        super.failedJob();
        this.activeJobs.decrementAndGet();
    }

    @Override
    public synchronized void cancelledJob() {
        super.cancelledJob();
        this.activeJobs.decrementAndGet();
    }

    public void incQueued() {
        this.queuedJobs.incrementAndGet();
    }

    public void decQueued() {
        this.queuedJobs.decrementAndGet();
    }

    public synchronized void clearQueued() {
        this.queuedJobs.set(0L);
    }

    @Override
    public synchronized void addActive(long queueTime) {
        super.addActive(queueTime);
        this.queuedJobs.decrementAndGet();
        this.activeJobs.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(StatisticsImpl other) {
        StatisticsImpl statisticsImpl = other;
        synchronized (statisticsImpl) {
            super.add(other);
            this.queuedJobs.addAndGet(other.queuedJobs.get());
            this.activeJobs.addAndGet(other.activeJobs.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(StatisticsImpl other) {
        long localActiveJobs;
        long localQueuedJobs;
        super.copyFrom(other);
        StatisticsImpl statisticsImpl = other;
        synchronized (statisticsImpl) {
            localQueuedJobs = other.queuedJobs.get();
            localActiveJobs = other.activeJobs.get();
        }
        statisticsImpl = this;
        synchronized (statisticsImpl) {
            this.queuedJobs.set(localQueuedJobs);
            this.activeJobs.set(localActiveJobs);
        }
    }

    @Override
    public synchronized void reset() {
        this.startTime.set(System.currentTimeMillis());
        super.reset();
    }
}

