/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.jobs.Utility;
import org.slf4j.Logger;

public class JobTopicTraverser {
    public static void traverse(Logger logger, Resource topicResource, JobCallback handler) {
        JobTopicTraverser.traverse(logger, topicResource, handler, null);
    }

    public static void traverse(Logger logger, Resource topicResource, ResourceCallback handler) {
        JobTopicTraverser.traverse(logger, topicResource, null, handler);
    }

    private static void traverse(Logger logger, Resource topicResource, JobCallback jobHandler, ResourceCallback resourceHandler) {
        logger.debug("Processing topic {}", (Object)topicResource.getName().replace('.', '/'));
        for (Resource yearResource : Utility.getSortedChildren(logger, "year", topicResource)) {
            logger.debug("Processing year {}", (Object)yearResource.getName());
            for (Resource monthResource : Utility.getSortedChildren(logger, "month", yearResource)) {
                logger.debug("Processing month {}", (Object)monthResource.getName());
                for (Resource dayResource : Utility.getSortedChildren(logger, "day", monthResource)) {
                    logger.debug("Processing day {}", (Object)dayResource.getName());
                    for (Resource hourResource : Utility.getSortedChildren(logger, "hour", dayResource)) {
                        logger.debug("Processing hour {}", (Object)hourResource.getName());
                        for (Resource minuteResource : Utility.getSortedChildren(logger, "minute", hourResource)) {
                            logger.debug("Processing minute {}", (Object)minuteResource.getName());
                            ArrayList<JobImpl> jobs = new ArrayList<JobImpl>();
                            Iterator jobIter = minuteResource.listChildren();
                            while (jobIter.hasNext()) {
                                Resource jobResource = (Resource)jobIter.next();
                                if (resourceHandler != null) {
                                    if (resourceHandler.handle(jobResource)) continue;
                                    return;
                                }
                                JobImpl job = Utility.readJob(logger, jobResource);
                                if (job == null) continue;
                                logger.debug("Found job {}", (Object)jobResource.getName());
                                jobs.add(job);
                            }
                            if (jobHandler == null) continue;
                            Collections.sort(jobs);
                            boolean stop = false;
                            for (JobImpl job : jobs) {
                                if (jobHandler.handle(job)) continue;
                                stop = true;
                            }
                            if (!stop) continue;
                            return;
                        }
                    }
                }
            }
        }
    }

    public static interface ResourceCallback {
        public boolean handle(Resource var1);
    }

    public static interface JobCallback {
        public boolean handle(JobImpl var1);
    }
}

