/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.serialization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sling.distribution.DistributionRequest;
import org.jetbrains.annotations.NotNull;

public class DistributionExportFilter {
    private final Set<TreeFilter> nodeFilters = new HashSet<TreeFilter>();
    private TreeFilter propertyFilter;

    private DistributionExportFilter() {
    }

    @NotNull
    public Set<TreeFilter> getNodeFilters() {
        return this.nodeFilters;
    }

    @NotNull
    public TreeFilter getPropertyFilter() {
        return this.propertyFilter;
    }

    public static DistributionExportFilter createFilter(DistributionRequest distributionRequest, NavigableMap<String, List<String>> nodeFilters, NavigableMap<String, List<String>> propertyFilters) {
        DistributionExportFilter exportFilter = new DistributionExportFilter();
        for (String path : distributionRequest.getPaths()) {
            boolean deep = distributionRequest.isDeep(path);
            TreeFilter treeFilter = new TreeFilter(path);
            if (deep) {
                treeFilter.addDeepInclude(path);
            } else {
                treeFilter.addInclude(path);
            }
            LinkedList<String> patterns = new LinkedList<String>();
            patterns.addAll(Arrays.asList(distributionRequest.getFilters(path)));
            DistributionExportFilter.initFilter(nodeFilters, treeFilter, patterns);
            exportFilter.addNodeFilter(treeFilter);
        }
        TreeFilter propertyFilterSet = new TreeFilter("/");
        DistributionExportFilter.initFilter(propertyFilters, propertyFilterSet, new ArrayList<String>());
        exportFilter.setPropertyFilter(propertyFilterSet);
        return exportFilter;
    }

    private void addNodeFilter(TreeFilter filter) {
        this.nodeFilters.add(filter);
    }

    private static void initFilter(NavigableMap<String, List<String>> globalFilters, TreeFilter treeFilter, List<String> patterns) {
        for (String key : globalFilters.descendingKeySet()) {
            if (!treeFilter.getPath().startsWith(key)) continue;
            patterns.addAll((Collection)globalFilters.get(key));
            break;
        }
        for (String pattern : patterns) {
            TreeFilter.Entry entry = DistributionExportFilter.extractPathPattern(pattern);
            if (entry.isInclude()) {
                treeFilter.addInclude(entry.getPath());
                continue;
            }
            treeFilter.addExclude(entry.getPath());
        }
    }

    private static TreeFilter.Entry extractPathPattern(String pattern) {
        TreeFilter.Entry result = pattern.startsWith("+") ? new TreeFilter.Entry(pattern.substring(1), true) : (pattern.startsWith("-") ? new TreeFilter.Entry(pattern.substring(1), false) : new TreeFilter.Entry(pattern, true));
        return result;
    }

    private void setPropertyFilter(TreeFilter propertyFilter) {
        this.propertyFilter = propertyFilter;
    }

    public String toString() {
        return "DistributionExportFilter{nodeFilters=" + this.nodeFilters + ", propertyFilter=" + this.propertyFilter + '}';
    }

    public static class TreeFilter {
        private final String path;
        private final Collection<String> includes;
        private final Collection<String> excludes;
        private final Collection<String> deepIncludes;

        public TreeFilter(String path) {
            this.path = path;
            this.includes = new TreeSet<String>();
            this.deepIncludes = new TreeSet<String>();
            this.excludes = new TreeSet<String>();
        }

        public void addInclude(String path) {
            this.includes.add(path);
        }

        public void addDeepInclude(String path) {
            this.deepIncludes.add(path);
        }

        public void addExclude(String path) {
            this.excludes.add(path);
        }

        @NotNull
        public String getPath() {
            return this.path;
        }

        public boolean matches(String path) {
            block1: {
                String di;
                boolean match;
                boolean bl = match = this.includes.isEmpty() && this.excludes.isEmpty() || this.includes.contains(path);
                if (match) break block1;
                Iterator<String> iterator = this.deepIncludes.iterator();
                while (iterator.hasNext() && !(match = path.startsWith(di = iterator.next()))) {
                }
            }
            return match &= !this.excludes.contains(path);
        }

        public String toString() {
            return "TreeFilter{path='" + this.path + '\'' + ", includes=" + this.includes + ", excludes=" + this.excludes + ", deepIncludes=" + this.deepIncludes + '}';
        }

        private static class Entry {
            private final String path;
            private final boolean include;

            public Entry(String path, boolean include) {
                this.path = path;
                this.include = include;
            }

            public boolean isInclude() {
                return this.include;
            }

            public String getPath() {
                return this.path;
            }
        }
    }
}

