/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.ContextUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.apache.sling.commons.log.logback.internal.LogbackResetListener;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.LoggerFactory;

public class FilterTracker
extends ServiceTracker<ch.qos.logback.core.filter.Filter<ILoggingEvent>, ch.qos.logback.core.filter.Filter<ILoggingEvent>>
implements LogbackResetListener {
    static final String ALL_APPENDERS = "*";
    static final String PROP_APPENDER = "appenders";
    private final LogConfigManager logConfigManager;
    private Map<ServiceReference<ch.qos.logback.core.filter.Filter<ILoggingEvent>>, FilterInfo> filters = new ConcurrentHashMap<ServiceReference<ch.qos.logback.core.filter.Filter<ILoggingEvent>>, FilterInfo>();

    public FilterTracker(@NotNull BundleContext context, @NotNull LogConfigManager logConfigManager) throws InvalidSyntaxException {
        super(context, FilterTracker.createFilter(), null);
        this.logConfigManager = logConfigManager;
    }

    @NotNull
    public ch.qos.logback.core.filter.Filter<ILoggingEvent> addingService(@NotNull ServiceReference<ch.qos.logback.core.filter.Filter<ILoggingEvent>> reference) {
        ch.qos.logback.core.filter.Filter f = (ch.qos.logback.core.filter.Filter)super.addingService(reference);
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        f.setContext((Context)loggerContext);
        f.start();
        FilterInfo fi = new FilterInfo(reference, (ch.qos.logback.core.filter.Filter<ILoggingEvent>)f);
        this.filters.put(reference, fi);
        this.attachFilter(fi, this.getAppenderMap());
        return f;
    }

    public void modifiedService(@NotNull ServiceReference<ch.qos.logback.core.filter.Filter<ILoggingEvent>> reference, @NotNull ch.qos.logback.core.filter.Filter<ILoggingEvent> service) {
        FilterInfo fi = this.filters.remove(reference);
        this.detachFilter(fi, this.getAppenderMap());
        this.filters.put(reference, new FilterInfo(reference, service));
        this.attachFilter(fi, this.getAppenderMap());
    }

    public void removedService(@NotNull ServiceReference<ch.qos.logback.core.filter.Filter<ILoggingEvent>> reference, @NotNull ch.qos.logback.core.filter.Filter<ILoggingEvent> service) {
        FilterInfo fi = this.filters.remove(reference);
        fi.stop();
        this.detachFilter(fi, this.getAppenderMap());
        super.removedService(reference, service);
    }

    public void attachedAppender(Appender<ILoggingEvent> appender) {
        for (FilterInfo fi : this.filters.values()) {
            this.attachFilter(fi, Map.of(appender.getName(), appender), false);
        }
    }

    public void detachedAppender(Appender<ILoggingEvent> appender) {
        for (FilterInfo fi : this.filters.values()) {
            this.detachFilter(fi, Map.of(appender.getName(), appender));
        }
    }

    public synchronized void close() {
        super.close();
        this.filters.clear();
    }

    @NotNull
    public Map<ServiceReference<ch.qos.logback.core.filter.Filter<ILoggingEvent>>, FilterInfo> getFilters() {
        return Collections.unmodifiableMap(this.filters);
    }

    @Override
    public void onResetComplete(@NotNull LoggerContext context) {
        Map<String, Appender<ILoggingEvent>> appenderMap = this.getAppenderMap();
        for (FilterInfo fi : this.filters.values()) {
            this.attachFilter(fi, appenderMap);
        }
    }

    private void attachFilter(@NotNull FilterInfo fi, @NotNull Map<String, Appender<ILoggingEvent>> appenderMap) {
        this.attachFilter(fi, appenderMap, true);
    }

    private void attachFilter(@NotNull FilterInfo fi, @NotNull Map<String, Appender<ILoggingEvent>> appenderMap, boolean warnOnNoMatch) {
        if (fi.registerAgainstAllAppenders) {
            for (Appender<ILoggingEvent> appender : appenderMap.values()) {
                this.attachFilter(appender, fi);
            }
            return;
        }
        for (String appenderName : fi.appenderNames) {
            Appender<ILoggingEvent> appender = appenderMap.get(appenderName);
            if (appender != null) {
                this.attachFilter(appender, fi);
                continue;
            }
            if (!warnOnNoMatch) continue;
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            new ContextUtil((Context)loggerContext).addWarn("No appender with name [" + appenderName + "] found to which " + String.valueOf(fi.filter) + " can be attached");
        }
    }

    private void detachFilter(@NotNull FilterInfo fi, @NotNull Map<String, Appender<ILoggingEvent>> appenderMap) {
        if (fi.registerAgainstAllAppenders) {
            for (Appender<ILoggingEvent> appender : appenderMap.values()) {
                this.detachFilter(appender, fi);
            }
            return;
        }
        for (String appenderName : fi.appenderNames) {
            Appender<ILoggingEvent> appender = appenderMap.get(appenderName);
            if (appender == null) continue;
            this.detachFilter(appender, fi);
        }
    }

    private void attachFilter(@NotNull Appender<ILoggingEvent> appender, @NotNull FilterInfo fi) {
        if (!appender.getCopyOfAttachedFiltersList().contains(fi.filter)) {
            appender.addFilter(fi.filter);
        }
    }

    private void detachFilter(@NotNull Appender<ILoggingEvent> appender, @NotNull FilterInfo fi) {
        if (appender.getCopyOfAttachedFiltersList().contains(fi.filter)) {
            List filtersCopy = appender.getCopyOfAttachedFiltersList();
            appender.clearAllFilters();
            for (ch.qos.logback.core.filter.Filter filter : filtersCopy) {
                if (fi.filter.equals((Object)filter)) continue;
                appender.addFilter(filter);
            }
        }
    }

    @NotNull
    private Map<String, Appender<ILoggingEvent>> getAppenderMap() {
        return this.logConfigManager.getAllKnownAppenders();
    }

    @NotNull
    private static Filter createFilter() throws InvalidSyntaxException {
        String filter = String.format("(&(objectClass=%s)(%s=*))", ch.qos.logback.core.filter.Filter.class.getName(), PROP_APPENDER);
        return FrameworkUtil.createFilter((String)filter);
    }

    static class FilterInfo {
        final ServiceReference<ch.qos.logback.core.filter.Filter<ILoggingEvent>> reference;
        final ch.qos.logback.core.filter.Filter<ILoggingEvent> filter;
        final Set<String> appenderNames;
        final boolean registerAgainstAllAppenders;

        FilterInfo(@NotNull ServiceReference<ch.qos.logback.core.filter.Filter<ILoggingEvent>> reference, @NotNull ch.qos.logback.core.filter.Filter<ILoggingEvent> filter) {
            this.reference = reference;
            this.filter = filter;
            Set appenderSet = (Set)((Converting)Converters.standardConverter().convert(reference.getProperty(FilterTracker.PROP_APPENDER)).defaultValue(Collections.emptySet())).to(Set.class);
            this.appenderNames = Collections.unmodifiableSet(appenderSet);
            this.registerAgainstAllAppenders = this.appenderNames.contains(FilterTracker.ALL_APPENDERS);
        }

        public void stop() {
            if (this.filter.isStarted()) {
                this.filter.stop();
            }
        }
    }
}

