/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import org.apache.felix.http.jakartawrappers.CookieWrapper;
import org.apache.felix.http.jakartawrappers.HttpServletRequestWrapper;
import org.apache.felix.http.jakartawrappers.RequestDispatcherWrapper;
import org.apache.felix.http.jakartawrappers.ServletRequestWrapper;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaxToJakartaRequestWrapper
extends HttpServletRequestWrapper
implements SlingJakartaHttpServletRequest {
    private final SlingHttpServletRequest wrappedRequest;

    @Nullable
    public static jakarta.servlet.ServletRequest toJakartaRequest(@Nullable ServletRequest request) {
        if (request == null) {
            return null;
        }
        if (request instanceof JakartaToJavaxRequestWrapper) {
            JakartaToJavaxRequestWrapper r = (JakartaToJavaxRequestWrapper)request;
            return r.getRequest();
        }
        if (request instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest r = (SlingHttpServletRequest)request;
            return new JavaxToJakartaRequestWrapper(r);
        }
        if (request instanceof javax.servlet.http.HttpServletRequest) {
            javax.servlet.http.HttpServletRequest r = (javax.servlet.http.HttpServletRequest)request;
            return new HttpServletRequestWrapper(r);
        }
        return new ServletRequestWrapper(request);
    }

    @Nullable
    public static HttpServletRequest toJakartaRequest(@Nullable javax.servlet.http.HttpServletRequest request) {
        return (HttpServletRequest)JavaxToJakartaRequestWrapper.toJakartaRequest((ServletRequest)request);
    }

    @Nullable
    public static SlingJakartaHttpServletRequest toJakartaRequest(@Nullable SlingHttpServletRequest request) {
        return (SlingJakartaHttpServletRequest)JavaxToJakartaRequestWrapper.toJakartaRequest((ServletRequest)request);
    }

    public JavaxToJakartaRequestWrapper(SlingHttpServletRequest wrappedRequest) {
        super((javax.servlet.http.HttpServletRequest)wrappedRequest);
        this.wrappedRequest = wrappedRequest;
    }

    @Override
    @Nullable
    public Cookie getCookie(String name) {
        javax.servlet.http.Cookie cookie = this.wrappedRequest.getCookie(name);
        if (cookie != null) {
            return new CookieWrapper(cookie);
        }
        return null;
    }

    @Override
    @Nullable
    public jakarta.servlet.RequestDispatcher getRequestDispatcher(@NotNull String path, RequestDispatcherOptions options) {
        RequestDispatcher dispatcher = this.wrappedRequest.getRequestDispatcher(path, options);
        if (dispatcher != null) {
            return new RequestDispatcherWrapper(dispatcher);
        }
        return null;
    }

    @Override
    @Nullable
    public jakarta.servlet.RequestDispatcher getRequestDispatcher(@NotNull Resource resource, RequestDispatcherOptions options) {
        RequestDispatcher dispatcher = this.wrappedRequest.getRequestDispatcher(resource, options);
        if (dispatcher != null) {
            return new RequestDispatcherWrapper(dispatcher);
        }
        return null;
    }

    @Override
    @Nullable
    public jakarta.servlet.RequestDispatcher getRequestDispatcher(@NotNull Resource resource) {
        RequestDispatcher dispatcher = this.wrappedRequest.getRequestDispatcher(resource);
        if (dispatcher != null) {
            return new RequestDispatcherWrapper(dispatcher);
        }
        return null;
    }

    @Override
    @Nullable
    public RequestParameter getRequestParameter(@NotNull String name) {
        return this.wrappedRequest.getRequestParameter(name);
    }

    @Override
    @NotNull
    public List<RequestParameter> getRequestParameterList() {
        return this.wrappedRequest.getRequestParameterList();
    }

    @Override
    @NotNull
    public RequestParameterMap getRequestParameterMap() {
        return this.wrappedRequest.getRequestParameterMap();
    }

    @Override
    @Nullable
    public RequestParameter[] getRequestParameters(@NotNull String name) {
        return this.wrappedRequest.getRequestParameters(name);
    }

    @Override
    @NotNull
    public RequestPathInfo getRequestPathInfo() {
        return this.wrappedRequest.getRequestPathInfo();
    }

    @Override
    @NotNull
    public RequestProgressTracker getRequestProgressTracker() {
        return this.wrappedRequest.getRequestProgressTracker();
    }

    @Override
    @NotNull
    public Resource getResource() {
        return this.wrappedRequest.getResource();
    }

    @Override
    @Nullable
    public ResourceBundle getResourceBundle(Locale locale) {
        return this.wrappedRequest.getResourceBundle(locale);
    }

    @Override
    @Nullable
    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        return this.wrappedRequest.getResourceBundle(baseName, locale);
    }

    @Override
    @NotNull
    public ResourceResolver getResourceResolver() {
        return this.wrappedRequest.getResourceResolver();
    }

    @Override
    @Nullable
    public String getResponseContentType() {
        return this.wrappedRequest.getResponseContentType();
    }

    @Override
    @NotNull
    public Enumeration<String> getResponseContentTypes() {
        return this.wrappedRequest.getResponseContentTypes();
    }

    @Override
    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> type) {
        return (AdapterType)this.wrappedRequest.adaptTo(type);
    }
}

