/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.NodeId;

public class Update
extends AbstractOperation {
    private final NodeState nodeState;
    private final String srcWorkspaceName;

    private Update(NodeState nodeState, String srcWorkspaceName) {
        this.nodeState = nodeState;
        this.srcWorkspaceName = srcWorkspaceName;
    }

    @Override
    public void accept(OperationVisitor visitor) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    @Override
    public void persisted() {
        assert (this.status == 0);
        this.status = 1;
        this.nodeState.getHierarchyEntry().invalidate(true);
    }

    public NodeId getNodeId() throws RepositoryException {
        return this.nodeState.getNodeEntry().getWorkspaceId();
    }

    public String getSourceWorkspaceName() {
        return this.srcWorkspaceName;
    }

    public static Operation create(NodeState nodeState, String srcWorkspaceName) {
        Update up = new Update(nodeState, srcWorkspaceName);
        return up;
    }
}

