/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance;

import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.PluginException;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.loader.InterceptorInstanceLoader;
import org.apache.skywalking.apm.agent.core.so11y.AgentSo11y;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.This;

public class ConstructorInter {
    private static final ILog LOGGER = LogManager.getLogger(ConstructorInter.class);
    private static final String INTERCEPTOR_TYPE = "constructor";
    private String pluginName;
    private InstanceConstructorInterceptor interceptor;

    public ConstructorInter(String pluginName, String constructorInterceptorClassName, ClassLoader classLoader) throws PluginException {
        this.pluginName = pluginName;
        try {
            this.interceptor = (InstanceConstructorInterceptor)InterceptorInstanceLoader.load(constructorInterceptorClassName, classLoader);
        }
        catch (Throwable t) {
            throw new PluginException("Can't create InstanceConstructorInterceptorV2.", t);
        }
    }

    @RuntimeType
    public void intercept(@This Object obj, @AllArguments Object[] allArguments) {
        long interceptorTimeCost = 0L;
        long startTime = System.nanoTime();
        try {
            EnhancedInstance targetObject = (EnhancedInstance)obj;
            this.interceptor.onConstruct(targetObject, allArguments);
        }
        catch (Throwable t) {
            LOGGER.error("ConstructorInter failure.", t);
            AgentSo11y.errorOfPlugin(this.pluginName, INTERCEPTOR_TYPE);
        }
        AgentSo11y.durationOfInterceptor(interceptorTimeCost += System.nanoTime() - startTime);
    }
}

