/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.concurrent.match;

import org.apache.skywalking.apm.agent.core.plugin.match.IndirectMatch;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatchers;

public abstract class EitherInterfaceMatch
implements IndirectMatch {
    private static final String SPRING_PACKAGE_PREFIX = "org.springframework";
    private static final String OBJECT_CLASS_NAME = "java.lang.Object";

    protected EitherInterfaceMatch() {
    }

    public ElementMatcher.Junction buildJunction() {
        return ElementMatchers.not((ElementMatcher)ElementMatchers.nameStartsWith((String)SPRING_PACKAGE_PREFIX)).and((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)this.getMatchInterface()))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)this.getMutexInterface()))));
    }

    public boolean isMatch(TypeDescription typeDescription) {
        MatchResult matchResult = new MatchResult();
        for (TypeDescription.Generic generic : typeDescription.getInterfaces()) {
            this.matchHierarchyClazz(generic, matchResult);
        }
        if (typeDescription.getSuperClass() != null) {
            this.matchHierarchyClazz(typeDescription.getSuperClass(), matchResult);
        }
        return matchResult.result();
    }

    public abstract String getMatchInterface();

    public abstract String getMutexInterface();

    private void matchHierarchyClazz(TypeDescription.Generic clazz, MatchResult matchResult) {
        if (clazz.asRawType().getTypeName().equals(this.getMutexInterface())) {
            matchResult.findMutexInterface = true;
            return;
        }
        if (clazz.asRawType().getTypeName().equals(this.getMatchInterface())) {
            matchResult.findMatchInterface = true;
        }
        for (TypeDescription.Generic generic : clazz.getInterfaces()) {
            this.matchHierarchyClazz(generic, matchResult);
        }
        TypeDescription.Generic superClazz = clazz.getSuperClass();
        if (superClazz != null && !clazz.getTypeName().equals(OBJECT_CLASS_NAME)) {
            this.matchHierarchyClazz(superClazz, matchResult);
        }
    }

    private static class MatchResult {
        private boolean findMatchInterface = false;
        private boolean findMutexInterface = false;

        private MatchResult() {
        }

        public boolean result() {
            return this.findMatchInterface && !this.findMutexInterface;
        }
    }
}

