/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.com.google.common.collect.ImmutableSet;
import graphql.execution.CoercedVariables;
import graphql.language.ArrayValue;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Internal
public class ValidationUtil {
    public TypeName getUnmodifiedType(Type<?> type) {
        if (type instanceof ListType) {
            return this.getUnmodifiedType(((ListType)type).getType());
        }
        if (type instanceof NonNullType) {
            return this.getUnmodifiedType(((NonNullType)type).getType());
        }
        if (type instanceof TypeName) {
            return (TypeName)type;
        }
        return (TypeName)Assert.assertShouldNeverHappen();
    }

    protected void handleNullError(Value<?> value, GraphQLType type) {
    }

    protected void handleScalarError(Value<?> value, GraphQLScalarType type, GraphQLError invalid) {
    }

    protected void handleEnumError(Value<?> value, GraphQLEnumType type, GraphQLError invalid) {
    }

    protected void handleNotObjectError(Value<?> value, GraphQLInputObjectType type) {
    }

    protected void handleMissingFieldsError(Value<?> value, GraphQLInputObjectType type, Set<String> missingFields) {
    }

    protected void handleExtraFieldError(Value<?> value, GraphQLInputObjectType type, ObjectField objectField) {
    }

    protected void handleFieldNotValidError(ObjectField objectField, GraphQLInputObjectType type) {
    }

    protected void handleFieldNotValidError(Value<?> value, GraphQLType type, int index) {
    }

    public boolean isValidLiteralValue(Value<?> value, GraphQLType type, GraphQLSchema schema, GraphQLContext graphQLContext, Locale locale) {
        if (value == null || value instanceof NullValue) {
            boolean valid;
            boolean bl = valid = !GraphQLTypeUtil.isNonNull(type);
            if (!valid) {
                this.handleNullError(value, type);
            }
            return valid;
        }
        if (value instanceof VariableReference) {
            return true;
        }
        if (GraphQLTypeUtil.isNonNull(type)) {
            return this.isValidLiteralValue(value, GraphQLTypeUtil.unwrapOne(type), schema, graphQLContext, locale);
        }
        if (type instanceof GraphQLScalarType) {
            Optional<GraphQLError> invalid = this.parseLiteral(value, ((GraphQLScalarType)type).getCoercing(), graphQLContext, locale);
            invalid.ifPresent(graphQLError -> this.handleScalarError(value, (GraphQLScalarType)type, (GraphQLError)graphQLError));
            return !invalid.isPresent();
        }
        if (type instanceof GraphQLEnumType) {
            Optional<GraphQLError> invalid = this.parseLiteralEnum(value, (GraphQLEnumType)type, graphQLContext, locale);
            invalid.ifPresent(graphQLError -> this.handleEnumError(value, (GraphQLEnumType)type, (GraphQLError)graphQLError));
            return !invalid.isPresent();
        }
        if (GraphQLTypeUtil.isList(type)) {
            return this.isValidLiteralValue(value, (GraphQLList)type, schema, graphQLContext, locale);
        }
        return type instanceof GraphQLInputObjectType && this.isValidLiteralValue(value, (GraphQLInputObjectType)type, schema, graphQLContext, locale);
    }

    private Optional<GraphQLError> parseLiteralEnum(Value<?> value, GraphQLEnumType graphQLEnumType, GraphQLContext graphQLContext, Locale locale) {
        try {
            graphQLEnumType.parseLiteral(value, graphQLContext, locale);
            return Optional.empty();
        }
        catch (CoercingParseLiteralException e) {
            return Optional.of(e);
        }
    }

    private Optional<GraphQLError> parseLiteral(Value<?> value, Coercing<?, ?> coercing, GraphQLContext graphQLContext, Locale locale) {
        try {
            coercing.parseLiteral(value, CoercedVariables.emptyVariables(), graphQLContext, locale);
            return Optional.empty();
        }
        catch (CoercingParseLiteralException e) {
            return Optional.of(e);
        }
    }

    boolean isValidLiteralValue(Value<?> value, GraphQLInputObjectType type, GraphQLSchema schema, GraphQLContext graphQLContext, Locale locale) {
        if (!(value instanceof ObjectValue)) {
            this.handleNotObjectError(value, type);
            return false;
        }
        GraphqlFieldVisibility fieldVisibility = schema.getCodeRegistry().getFieldVisibility();
        ObjectValue objectValue = (ObjectValue)value;
        Map<String, ObjectField> objectFieldMap = this.fieldMap(objectValue);
        Set<String> missingFields = this.getMissingFields(type, objectFieldMap, fieldVisibility);
        if (!missingFields.isEmpty()) {
            this.handleMissingFieldsError(value, type, missingFields);
            return false;
        }
        for (ObjectField objectField : objectValue.getObjectFields()) {
            GraphQLInputObjectField inputObjectField = fieldVisibility.getFieldDefinition(type, objectField.getName());
            if (inputObjectField == null) {
                this.handleExtraFieldError(value, type, objectField);
                return false;
            }
            if (this.isValidLiteralValue(objectField.getValue(), inputObjectField.getType(), schema, graphQLContext, locale)) continue;
            this.handleFieldNotValidError(objectField, type);
            return false;
        }
        return true;
    }

    private Set<String> getMissingFields(GraphQLInputObjectType type, Map<String, ObjectField> objectFieldMap, GraphqlFieldVisibility fieldVisibility) {
        return fieldVisibility.getFieldDefinitions(type).stream().filter(field -> GraphQLTypeUtil.isNonNull(field.getType())).filter(value -> value.getInputFieldDefaultValue().isNotSet() && !objectFieldMap.containsKey(value.getName())).map(GraphQLInputObjectField::getName).collect(ImmutableSet.toImmutableSet());
    }

    private Map<String, ObjectField> fieldMap(ObjectValue objectValue) {
        LinkedHashMap<String, ObjectField> result = new LinkedHashMap<String, ObjectField>();
        for (ObjectField objectField : objectValue.getObjectFields()) {
            result.put(objectField.getName(), objectField);
        }
        return result;
    }

    private boolean isValidLiteralValue(Value<?> value, GraphQLList type, GraphQLSchema schema, GraphQLContext graphQLContext, Locale locale) {
        GraphQLType wrappedType = type.getWrappedType();
        if (value instanceof ArrayValue) {
            List<Value> values = ((ArrayValue)value).getValues();
            for (int i = 0; i < values.size(); ++i) {
                if (this.isValidLiteralValue(values.get(i), wrappedType, schema, graphQLContext, locale)) continue;
                this.handleFieldNotValidError(values.get(i), wrappedType, i);
                return false;
            }
            return true;
        }
        return this.isValidLiteralValue(value, wrappedType, schema, graphQLContext, locale);
    }
}

