/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.CanNotProbeException;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.IllegalOpenParameterException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.base.StoreMetadata;
import org.apache.sis.storage.sql.ResourceDefinition;
import org.apache.sis.storage.sql.SimpleFeatureStore;
import org.apache.sis.storage.sql.feature.Resources;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.UnconvertibleObjectException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

@StoreMetadata(formatName="SQL", capabilities={Capability.READ}, resourceTypes={Aggregate.class, FeatureSet.class})
public class SQLStoreProvider
extends DataStoreProvider {
    static final String NAME = "SQL";
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.storage.sql");
    static final String TABLES = "tables";
    static final String QUERIES = "queries";
    public static final ParameterDescriptor<DataSource> SOURCE_PARAM;
    public static final ParameterDescriptor<GenericName[]> TABLES_PARAM;
    public static final ParameterDescriptor<Map<?, ?>> QUERIES_PARAM;
    private static final ParameterDescriptorGroup OPEN_DESCRIPTOR;

    public static GenericName createTableName(String catalog, String schemaPattern, String tablePattern) {
        return ResourceDefinition.table(catalog, schemaPattern, tablePattern).getName();
    }

    public String getShortName() {
        return NAME;
    }

    public ParameterDescriptorGroup getOpenParameters() {
        return OPEN_DESCRIPTOR;
    }

    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        block10: {
            DataSource ds = (DataSource)connector.getStorageAs(DataSource.class);
            if (ds != null) {
                ProbeResult probeResult;
                block9: {
                    Connection c = ds.getConnection();
                    try {
                        probeResult = ProbeResult.SUPPORTED;
                        if (c == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (c != null) {
                                try {
                                    c.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            String state = e.getSQLState();
                            if ("08001".equals(state) || "3D000".equals(state)) break block10;
                            throw new CanNotProbeException((DataStoreProvider)this, connector, (Throwable)Exceptions.unwrap((Exception)e));
                        }
                    }
                    c.close();
                }
                return probeResult;
            }
        }
        return ProbeResult.UNSUPPORTED_STORAGE;
    }

    public DataStore open(StorageConnector connector) throws DataStoreException {
        return new SimpleFeatureStore(this, connector, ResourceDefinition.table("%"));
    }

    public DataStore open(ParameterValueGroup parameters) throws DataStoreException {
        try {
            Parameters p = Parameters.castOrWrap((ParameterValueGroup)Objects.requireNonNull(parameters));
            StorageConnector connector = new StorageConnector(p.getValue(SOURCE_PARAM));
            GenericName[] tableNames = (GenericName[])p.getValue(TABLES_PARAM);
            Map queries = (Map)p.getValue(QUERIES_PARAM);
            return new SimpleFeatureStore(this, connector, ResourceDefinition.wrap(tableNames, queries));
        }
        catch (UnconvertibleObjectException | ParameterNotFoundException e) {
            throw new IllegalOpenParameterException(e.getMessage(), e);
        }
    }

    public Logger getLogger() {
        return LOGGER;
    }

    static {
        Class<Map> map = Map.class;
        ParameterBuilder builder = new ParameterBuilder();
        SOURCE_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)"location")).setRequired(true).setDescription((CharSequence)Resources.formatInternational((short)1))).create(DataSource.class, null);
        TABLES_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)TABLES)).setRequired(false).setDescription((CharSequence)Resources.formatInternational((short)2))).create(GenericName[].class, null);
        QUERIES_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)QUERIES)).setDescription((CharSequence)Resources.formatInternational((short)14))).create(map, null);
        OPEN_DESCRIPTOR = ((ParameterBuilder)builder.addName((CharSequence)NAME)).createGroup(new GeneralParameterDescriptor[]{SOURCE_PARAM, TABLES_PARAM, QUERIES_PARAM});
    }
}

