/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.aliyun.sls.handler;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.aliyun.sls.client.AliyunSlsLogCollectClient;
import org.apache.shenyu.plugin.aliyun.sls.collector.AliyunSlsLogCollector;
import org.apache.shenyu.plugin.aliyun.sls.config.AliyunLogCollectConfig;
import org.apache.shenyu.plugin.logging.common.collector.LogCollector;
import org.apache.shenyu.plugin.logging.common.config.GenericApiConfig;
import org.apache.shenyu.plugin.logging.common.handler.AbstractLogPluginDataHandler;

public class LoggingAliyunSlsPluginDataHandler
extends AbstractLogPluginDataHandler<AliyunLogCollectConfig.AliyunSlsLogConfig, GenericApiConfig> {
    private static final AliyunSlsLogCollectClient ALIYUN_SLS_LOG_COLLECT_CLIENT = new AliyunSlsLogCollectClient();

    protected LogCollector logCollector() {
        return AliyunSlsLogCollector.getInstance();
    }

    protected void doRefreshConfig(AliyunLogCollectConfig.AliyunSlsLogConfig globalLogConfig) {
        AliyunLogCollectConfig.INSTANCE.setAliyunSlsLogConfig(globalLogConfig);
        if (Objects.isNull((Object)globalLogConfig) || StringUtils.isBlank((CharSequence)globalLogConfig.getHost()) || StringUtils.isBlank((CharSequence)globalLogConfig.getAccessId()) || StringUtils.isBlank((CharSequence)globalLogConfig.getAccessKey())) {
            LOG.error("aliyun sls props is empty. failed init aliyun sls producer");
            return;
        }
        ALIYUN_SLS_LOG_COLLECT_CLIENT.initClient(globalLogConfig);
    }

    public String pluginNamed() {
        return PluginEnum.LOGGING_ALIYUN_SLS.getName();
    }

    public static AliyunSlsLogCollectClient getAliyunSlsLogCollectClient() {
        return ALIYUN_SLS_LOG_COLLECT_CLIENT;
    }
}

