/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.rpc.protocol.tars;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qq.tars.common.support.ClassLoaderManager;
import com.qq.tars.common.support.Holder;
import com.qq.tars.common.util.CollectionUtils;
import com.qq.tars.common.util.JSON;
import com.qq.tars.common.util.StringUtils;
import com.qq.tars.net.core.IoBuffer;
import com.qq.tars.net.core.Request;
import com.qq.tars.net.core.Response;
import com.qq.tars.net.core.Session;
import com.qq.tars.net.protocol.ProtocolException;
import com.qq.tars.protocol.tars.TarsInputStream;
import com.qq.tars.protocol.tars.TarsOutputStream;
import com.qq.tars.protocol.tars.support.TarsMethodInfo;
import com.qq.tars.protocol.tars.support.TarsMethodParameterInfo;
import com.qq.tars.protocol.util.TarsHelper;
import com.qq.tars.protocol.util.TarsUtil;
import com.qq.tars.rpc.protocol.Codec;
import com.qq.tars.rpc.protocol.ServantRequest;
import com.qq.tars.rpc.protocol.ServantResponse;
import com.qq.tars.rpc.protocol.tars.TarsServantRequest;
import com.qq.tars.rpc.protocol.tars.TarsServantResponse;
import com.qq.tars.rpc.protocol.tars.support.AnalystManager;
import com.qq.tars.rpc.protocol.tup.UniAttribute;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TarsCodec
extends Codec {
    public TarsCodec(String charsetName) {
        super(charsetName);
    }

    public IoBuffer encodeResponse(Response resp, Session session) throws ProtocolException {
        TarsOutputStream jos;
        block15: {
            TarsServantResponse response = (TarsServantResponse)resp;
            if (response.getPacketType() == 1) {
                return null;
            }
            jos = new TarsOutputStream();
            jos.setServerEncoding(this.charsetName);
            try {
                jos.getByteBuffer().putInt(0);
                jos.write(response.getVersion(), 1);
                jos.write(response.getPacketType(), 2);
                if (response.getVersion() == 1) {
                    jos.write(response.getRequestId(), 3);
                    jos.write(response.getMessageType(), 4);
                    jos.write(response.getRet(), 5);
                    jos.write(this.encodeResult(response, this.charsetName), 6);
                    if (response.getStatus() != null) {
                        jos.write(response.getStatus(), 7);
                    }
                    if (response.getRet() != 0) {
                        jos.write(StringUtils.isEmpty(response.getRemark()) ? "" : response.getRemark(), 8);
                    }
                } else if (2 == response.getVersion() || 3 == response.getVersion()) {
                    jos.write(response.getMessageType(), 3);
                    jos.write(response.getRequestId(), 4);
                    String servantName = response.getRequest().getServantName();
                    jos.write(servantName, 5);
                    jos.write(response.getRequest().getFunctionName(), 6);
                    jos.write(this.encodeWupResult(response, this.charsetName), 7);
                    jos.write(response.getTimeout(), 8);
                    if (response.getContext() != null) {
                        jos.write(response.getContext(), 9);
                    }
                    if (response.getStatus() != null) {
                        jos.write(response.getStatus(), 10);
                    }
                } else if (response.getVersion() == 5) {
                    jos.write(response.getRequestId(), 3);
                    jos.write(response.getMessageType(), 4);
                    jos.write(response.getRet(), 5);
                    jos.write(this.encodeJsonResult(response, this.charsetName), 6);
                    if (response.getStatus() != null) {
                        jos.write(response.getStatus(), 7);
                    }
                    if (response.getRet() != 0) {
                        jos.write(StringUtils.isEmpty(response.getRemark()) ? "" : response.getRemark(), 8);
                    }
                } else {
                    response.setRet(-2);
                    System.err.println("un supported protocol, ver=" + response.getVersion());
                }
            }
            catch (Exception ex) {
                if (response.getRet() != 0) break block15;
                response.setRet(-2);
            }
        }
        ByteBuffer buffer = jos.getByteBuffer();
        int datalen = buffer.position();
        buffer.position(0);
        buffer.putInt(datalen);
        buffer.position(datalen);
        return IoBuffer.wrap((byte[])jos.toByteArray());
    }

    protected byte[] encodeResult(TarsServantResponse response, String charsetName) {
        TarsServantRequest request = response.getRequest();
        if (TarsHelper.isPing(request.getFunctionName())) {
            return new byte[0];
        }
        TarsOutputStream ajos = new TarsOutputStream();
        ajos.setServerEncoding(charsetName);
        int ret = response.getRet();
        Map<String, TarsMethodInfo> methodInfoMap = AnalystManager.getInstance().getMethodMapByName(request.getServantName());
        if (ret == 0 && methodInfoMap != null) {
            TarsMethodInfo methodInfo = methodInfoMap.get(request.getFunctionName());
            TarsMethodParameterInfo returnInfo = methodInfo.getReturnInfo();
            if (returnInfo != null && returnInfo.getType() != Void.TYPE && response.getResult() != null) {
                try {
                    ajos.write(response.getResult(), methodInfo.getReturnInfo().getOrder());
                }
                catch (Exception e) {
                    System.err.println("server encodec response result:" + response.getResult() + " with ex:" + e);
                }
            }
            Object value = null;
            List<TarsMethodParameterInfo> parametersList = methodInfo.getParametersList();
            for (TarsMethodParameterInfo parameterInfo : parametersList) {
                if (!TarsHelper.isHolder(parameterInfo.getAnnotations()) || (value = request.getMethodParameters()[parameterInfo.getOrder() - 1]) == null) continue;
                try {
                    ajos.write(TarsHelper.getHolderValue(value), parameterInfo.getOrder());
                }
                catch (Exception e) {
                    System.err.println("server encodec response holder:" + value + " with ex:" + e);
                }
            }
        }
        return ajos.toByteArray();
    }

    protected byte[] encodeJsonResult(TarsServantResponse response, String charsetName) {
        TarsServantRequest request = response.getRequest();
        if (TarsHelper.isPing(request.getFunctionName())) {
            return new byte[0];
        }
        JsonObject object = new JsonObject();
        int ret = response.getRet();
        Map<String, TarsMethodInfo> methodInfoMap = AnalystManager.getInstance().getMethodMapByName(request.getServantName());
        if (ret == 0 && methodInfoMap != null) {
            TarsMethodInfo methodInfo = methodInfoMap.get(request.getFunctionName());
            TarsMethodParameterInfo returnInfo = methodInfo.getReturnInfo();
            if (returnInfo != null && returnInfo.getType() != Void.TYPE && response.getResult() != null) {
                try {
                    JsonElement jsonElement = JSON.toJsonTree(response.getResult());
                    object.add("tars_ret", jsonElement);
                }
                catch (Exception e) {
                    System.err.println("server encode json ret :" + response.getResult() + ", with ex:" + e);
                }
            }
            Object value = null;
            List<TarsMethodParameterInfo> parametersList = methodInfo.getParametersList();
            for (TarsMethodParameterInfo parameterInfo : parametersList) {
                if (!TarsHelper.isHolder(parameterInfo.getAnnotations()) || (value = request.getMethodParameters()[parameterInfo.getOrder() - 1]) == null) continue;
                try {
                    JsonElement jsonElement = JSON.toJsonTree(TarsHelper.getHolderValue(value));
                    object.add(parameterInfo.getName(), jsonElement);
                }
                catch (Exception e) {
                    System.err.println("server encode json holder :" + value + ", with ex:" + e);
                }
            }
        }
        String result = object.toString();
        try {
            byte[] data = result.getBytes(charsetName);
            return data;
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("server encode json encode :" + result + ", with charset:" + charsetName + ", with ex: " + e);
            return new byte[0];
        }
    }

    protected byte[] encodeWupResult(TarsServantResponse response, String charsetName) {
        TarsServantRequest request = response.getRequest();
        UniAttribute unaOut = new UniAttribute();
        unaOut.setEncodeName(charsetName);
        if (response.getVersion() == 3) {
            unaOut.useVersion3();
        } else if (response.getVersion() == 2) {
            unaOut.setNewDataNull();
        }
        int ret = response.getRet();
        Map<String, TarsMethodInfo> methodInfoMap = AnalystManager.getInstance().getMethodMapByName(request.getServantName());
        if (ret == 0 && methodInfoMap != null) {
            TarsMethodInfo methodInfo = methodInfoMap.get(request.getFunctionName());
            TarsMethodParameterInfo returnInfo = methodInfo.getReturnInfo();
            if (returnInfo != null && returnInfo.getType() != Void.TYPE && response.getResult() != null) {
                unaOut.put("", response.getResult());
            }
            Object value = null;
            List<TarsMethodParameterInfo> parametersList = methodInfo.getParametersList();
            for (TarsMethodParameterInfo parameterInfo : parametersList) {
                if (!TarsHelper.isHolder(parameterInfo.getAnnotations()) || (value = request.getMethodParameters()[parameterInfo.getOrder() - 1]) == null) continue;
                try {
                    String holderName = TarsHelper.getHolderName(parameterInfo.getAnnotations());
                    if (StringUtils.isEmpty(holderName)) continue;
                    unaOut.put(holderName, TarsHelper.getHolderValue(value));
                }
                catch (Exception e) {
                    System.err.println("server encodec response holder:" + value + " with ex:" + e);
                }
            }
        }
        return unaOut.encode();
    }

    public IoBuffer encodeRequest(Request req, Session session) throws ProtocolException {
        TarsServantRequest request = (TarsServantRequest)req;
        request.setCharsetName(this.charsetName);
        TarsOutputStream os = new TarsOutputStream();
        os.setServerEncoding(this.charsetName);
        os.getByteBuffer().putInt(0);
        os.write(request.getVersion(), 1);
        os.write(request.getPacketType(), 2);
        os.write(request.getMessageType(), 3);
        os.write(request.getRequestId(), 4);
        os.write(request.getServantName(), 5);
        os.write(request.getFunctionName(), 6);
        os.write(this.encodeRequestParams(request, this.charsetName), 7);
        os.write(request.getTimeout(), 8);
        os.write(request.getContext(), 9);
        os.write(request.getStatus(), 10);
        os.getByteBuffer().flip();
        int length = os.getByteBuffer().remaining();
        os.getByteBuffer().duplicate().putInt(0, length);
        if (length > 0xA00000 || length <= 0) {
            throw new ProtocolException("the length header of the package must be between 0~10M bytes. data length:" + Integer.toHexString(length));
        }
        return IoBuffer.wrap((ByteBuffer)os.getByteBuffer());
    }

    protected byte[] encodeRequestParams(TarsServantRequest request, String charsetName) throws ProtocolException {
        TarsOutputStream os = new TarsOutputStream(0);
        os.setServerEncoding(charsetName);
        TarsMethodInfo methodInfo = request.getMethodInfo();
        List<TarsMethodParameterInfo> parameterInfoList = methodInfo.getParametersList();
        Object value = null;
        Object[] parameter = request.getMethodParameters();
        for (TarsMethodParameterInfo parameterInfo : parameterInfoList) {
            if (TarsHelper.isContext(parameterInfo.getAnnotations()) || TarsHelper.isCallback(parameterInfo.getAnnotations())) continue;
            value = parameter[request.isAsync() ? parameterInfo.getOrder() : parameterInfo.getOrder() - 1];
            if (TarsHelper.isHolder(parameterInfo.getAnnotations()) && value != null) {
                try {
                    value = TarsHelper.getHolderValue(value);
                }
                catch (Exception e) {
                    throw new ProtocolException((Throwable)e);
                }
                if (value == null) continue;
                os.write(value, parameterInfo.getOrder());
                continue;
            }
            if (value == null) continue;
            os.write(value, parameterInfo.getOrder());
        }
        return os.toByteArray();
    }

    public Request decodeRequest(IoBuffer buffer, Session session) throws ProtocolException {
        if (buffer.remaining() < 4) {
            return null;
        }
        int length = buffer.getInt() - 4;
        if (length > 0xA00000 || length <= 0) {
            throw new ProtocolException("the length header of the package must be between 0~10M bytes. data length:" + Integer.toHexString(length));
        }
        if (buffer.remaining() < length) {
            return null;
        }
        byte[] reads = new byte[length];
        buffer.get(reads);
        TarsInputStream jis = new TarsInputStream(reads);
        TarsServantRequest request = new TarsServantRequest(session);
        try {
            short version = jis.read(TarsHelper.STAMP_SHORT, 1, true);
            byte packetType = jis.read(TarsHelper.STAMP_BYTE, 2, true);
            int messageType = jis.read(TarsHelper.STAMP_INT, 3, true);
            int requestId = jis.read(TarsHelper.STAMP_INT, 4, true);
            String servantName = jis.readString(5, true);
            String methodName = jis.readString(6, true);
            request.setVersion(version);
            request.setPacketType(packetType);
            request.setMessageType(messageType);
            request.setRequestId(requestId);
            request.setServantName(servantName);
            request.setFunctionName(methodName);
            request.setInputStream(jis);
            request.setCharsetName(this.charsetName);
        }
        catch (Exception e) {
            System.err.println(e);
            request.setRet(-1);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServantRequest decodeRequestBody(ServantRequest req) {
        TarsServantRequest request = (TarsServantRequest)req;
        if (request.getRet() != 0) {
            return request;
        }
        if (TarsHelper.isPing(request.getFunctionName())) {
            return request;
        }
        TarsInputStream jis = request.getInputStream();
        ClassLoader oldClassLoader = null;
        try {
            oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.resolveProtocolClassLoader());
            String methodName = request.getFunctionName();
            byte[] data = jis.read(TarsHelper.STAMP_BYTE_ARRAY, 7, true);
            int timeout = jis.read(TarsHelper.STAMP_INT, 8, true);
            Map context = (Map)jis.read(TarsHelper.STAMP_MAP, 9, true);
            Map status = (Map)jis.read(TarsHelper.STAMP_MAP, 10, true);
            request.setTimeout(timeout);
            request.setContext(context);
            request.setStatus(status);
            String servantName = request.getServantName();
            Map<String, TarsMethodInfo> methodInfoMap = AnalystManager.getInstance().getMethodMapByName(servantName);
            if (methodInfoMap == null || methodInfoMap.isEmpty()) {
                request.setRet(-4);
                throw new ProtocolException("no found methodInfo, the context[ROOT], serviceName[" + servantName + "], methodName[" + methodName + "]");
            }
            TarsMethodInfo methodInfo = methodInfoMap.get(methodName);
            if (methodInfo == null) {
                request.setRet(-3);
                throw new ProtocolException("no found methodInfo, the context[ROOT], serviceName[" + servantName + "], methodName[" + methodName + "]");
            }
            request.setMethodInfo(methodInfo);
            List<TarsMethodParameterInfo> parametersList = methodInfo.getParametersList();
            if (CollectionUtils.isNotEmpty(parametersList)) {
                Object[] parameters = new Object[parametersList.size()];
                boolean i = false;
                if (1 == request.getVersion()) {
                    parameters = this.decodeRequestBody(data, request.getCharsetName(), methodInfo);
                } else if (2 == request.getVersion() || 3 == request.getVersion()) {
                    parameters = this.decodeRequestWupBody(data, request.getVersion(), request.getCharsetName(), methodInfo);
                } else if (5 == request.getVersion()) {
                    parameters = this.decodeRequestJsonBody(data, request.getCharsetName(), methodInfo);
                } else {
                    request.setRet(-1);
                    System.err.println("un supported protocol, ver=" + request.getVersion());
                }
                request.setMethodParameters(parameters);
            }
        }
        catch (Throwable ex) {
            if (request.getRet() == 0) {
                request.setRet(-1);
            }
            System.err.println(TarsUtil.getHexdump(jis.getBs()));
        }
        finally {
            if (oldClassLoader != null) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        return request;
    }

    protected Object[] decodeRequestBody(byte[] data, String charset, TarsMethodInfo methodInfo) throws Exception {
        TarsInputStream jis = new TarsInputStream(data);
        List<TarsMethodParameterInfo> parametersList = methodInfo.getParametersList();
        Object[] parameters = new Object[parametersList.size()];
        int i = 0;
        jis.setServerEncoding(charset);
        Holder<Object> value = null;
        for (TarsMethodParameterInfo parameterInfo : parametersList) {
            Object response;
            value = TarsHelper.isHolder(parameterInfo.getAnnotations()) ? ((response = jis.read(parameterInfo.getStamp(), parameterInfo.getOrder(), false)) != null ? new Holder<Object>(response) : new Holder<Object>(TarsHelper.getNewParameterStamp(parameterInfo.getType()))) : jis.read(parameterInfo.getStamp(), parameterInfo.getOrder(), false);
            parameters[i++] = value;
        }
        return parameters;
    }

    protected Object[] decodeRequestWupBody(byte[] data, int version, String charset, TarsMethodInfo methodInfo) throws Exception {
        UniAttribute unaIn = new UniAttribute();
        unaIn.setEncodeName(this.charsetName);
        if (version == 2) {
            unaIn.decodeVersion2(data);
        } else if (version == 3) {
            unaIn.decodeVersion3(data);
        }
        List<TarsMethodParameterInfo> parametersList = methodInfo.getParametersList();
        Object[] parameters = new Object[parametersList.size()];
        int i = 0;
        Holder<Object> value = null;
        for (TarsMethodParameterInfo parameterInfo : parametersList) {
            String holderName;
            value = TarsHelper.isHolder(parameterInfo.getAnnotations()) ? (unaIn.containsKey(holderName = TarsHelper.getHolderName(parameterInfo.getAnnotations())) ? new Holder<Object>(unaIn.getByClass(holderName, parameterInfo.getStamp())) : new Holder<Object>(TarsHelper.getNewParameterStamp(parameterInfo.getType()))) : unaIn.getByClass(parameterInfo.getName(), parameterInfo.getStamp());
            parameters[i++] = value;
        }
        return parameters;
    }

    protected Object[] decodeRequestJsonBody(byte[] data, String charset, TarsMethodInfo methodInfo) throws Exception {
        JsonObject jsonObject = JSON.fromJson(new String(data, charset), JsonObject.class);
        int i = 0;
        Holder<Object> value = null;
        List<TarsMethodParameterInfo> parametersList = methodInfo.getParametersList();
        Object[] parameters = new Object[parametersList.size()];
        for (TarsMethodParameterInfo parameterInfo : parametersList) {
            String reqStr;
            if (TarsHelper.isHolder(parameterInfo.getAnnotations())) {
                if (jsonObject.has(parameterInfo.getName())) {
                    reqStr = jsonObject.get(parameterInfo.getName()).toString();
                    value = new Holder(JSON.fromJson(reqStr, parameterInfo.getStamp().getClass()));
                } else {
                    value = new Holder<Object>(TarsHelper.getNewParameterStamp(parameterInfo.getType()));
                }
            } else if (jsonObject.has(parameterInfo.getName())) {
                reqStr = jsonObject.get(parameterInfo.getName()).toString();
                value = JSON.fromJson(reqStr, parameterInfo.getType());
            } else {
                System.out.println("request has no " + parameterInfo.getName() + ", exception.");
                throw new ProtocolException("no found parameter, the context[ROOT], serviceName[" + methodInfo.getServiceName() + "], methodName[" + methodInfo.getMethodName() + "], parameter[" + parameterInfo.getName() + "]");
            }
            parameters[i++] = value;
        }
        return parameters;
    }

    public Response decodeResponse(IoBuffer buffer, Session session) throws ProtocolException {
        if (buffer.remaining() < 4) {
            return null;
        }
        int length = buffer.getInt() - 4;
        if (length > 0xA00000 || length <= 0) {
            throw new ProtocolException("the length header of the package must be between 0~10M bytes. data length:" + Integer.toHexString(length));
        }
        if (buffer.remaining() < length) {
            return null;
        }
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        TarsServantResponse response = new TarsServantResponse(session);
        response.setCharsetName(this.charsetName);
        TarsInputStream is = new TarsInputStream(bytes);
        is.setServerEncoding(this.charsetName);
        response.setVersion(is.read((short)0, 1, true));
        response.setPacketType(is.read((byte)0, 2, true));
        response.setRequestId(is.read(0, 3, true));
        response.setMessageType(is.read(0, 4, true));
        response.setRet(is.read(0, 5, true));
        if (response.getRet() == 0) {
            response.setInputStream(is);
        } else {
            response.setRemark(is.read("", 8, true));
        }
        return response;
    }

    public void decodeResponseBody(ServantResponse resp) throws ProtocolException {
        Object[] results;
        TarsServantResponse response = (TarsServantResponse)resp;
        TarsServantRequest request = response.getRequest();
        if (request.isAsync()) {
            return;
        }
        TarsInputStream is = response.getInputStream();
        byte[] data = is.read(new byte[0], 6, true);
        TarsInputStream jis = new TarsInputStream(data);
        jis.setServerEncoding(response.getCharsetName());
        TarsMethodInfo methodInfo = request.getMethodInfo();
        TarsMethodParameterInfo returnInfo = methodInfo.getReturnInfo();
        try {
            results = this.decodeResponseBody(data, response.getCharsetName(), methodInfo);
        }
        catch (Exception e) {
            throw new ProtocolException((Throwable)e);
        }
        int i = 0;
        if (returnInfo != null && Void.TYPE != returnInfo.getType()) {
            response.setResult(results[i++]);
        }
        List<TarsMethodParameterInfo> list = methodInfo.getParametersList();
        for (TarsMethodParameterInfo info : list) {
            if (!TarsHelper.isHolder(info.getAnnotations())) continue;
            try {
                TarsHelper.setHolderValue(request.getMethodParameters()[info.getOrder() - 1], results[i++]);
            }
            catch (Exception e) {
                throw new ProtocolException((Throwable)e);
            }
        }
        response.setStatus((HashMap)is.read(TarsHelper.STAMP_MAP, 7, false));
    }

    protected Object[] decodeResponseBody(byte[] data, String charset, TarsMethodInfo methodInfo) throws Exception {
        TarsMethodParameterInfo returnInfo = methodInfo.getReturnInfo();
        ArrayList<Object> values = new ArrayList<Object>();
        TarsInputStream jis = new TarsInputStream(data);
        jis.setServerEncoding(charset);
        if (returnInfo != null && Void.TYPE != returnInfo.getType()) {
            values.add(jis.read(returnInfo.getStamp(), returnInfo.getOrder(), true));
        }
        List<TarsMethodParameterInfo> list = methodInfo.getParametersList();
        for (TarsMethodParameterInfo info : list) {
            if (!TarsHelper.isHolder(info.getAnnotations())) continue;
            try {
                values.add(jis.read(info.getStamp(), info.getOrder(), true));
            }
            catch (Exception e) {
                throw new ProtocolException((Throwable)e);
            }
        }
        return values.toArray();
    }

    public Object[] decodeCallbackArgs(TarsServantResponse response) throws ProtocolException {
        byte[] data = response.getInputStream().read(new byte[0], 6, true);
        TarsServantRequest request = response.getRequest();
        TarsMethodInfo methodInfo = null;
        Map<Method, TarsMethodInfo> map = AnalystManager.getInstance().getMethodMap(request.getApi());
        for (Map.Entry<Method, TarsMethodInfo> entry : map.entrySet()) {
            if (!entry.getKey().getName().equals(request.getFunctionName())) continue;
            methodInfo = entry.getValue();
        }
        try {
            return this.decodeCallbackArgs(data, response.getCharsetName(), methodInfo);
        }
        catch (Exception e) {
            throw new ProtocolException((Throwable)e);
        }
    }

    protected Object[] decodeCallbackArgs(byte[] data, String charset, TarsMethodInfo methodInfo) throws ProtocolException, NoSuchMethodException, Exception {
        TarsInputStream jis = new TarsInputStream(data);
        jis.setServerEncoding(charset);
        ArrayList<Object> list = new ArrayList<Object>();
        TarsMethodParameterInfo returnInfo = methodInfo.getReturnInfo();
        if (returnInfo != null && Void.TYPE != returnInfo.getType()) {
            list.add(jis.read(returnInfo.getStamp(), returnInfo.getOrder(), true));
        }
        List<TarsMethodParameterInfo> parameterInfoList = methodInfo.getParametersList();
        for (TarsMethodParameterInfo info : parameterInfoList) {
            if (TarsHelper.isContext(info.getAnnotations()) || TarsHelper.isCallback(info.getAnnotations()) || !TarsHelper.isHolder(info.getAnnotations())) continue;
            list.add(jis.read(info.getStamp(), info.getOrder(), false));
        }
        return list.toArray();
    }

    protected ClassLoader resolveProtocolClassLoader() {
        ClassLoader classLoader = ClassLoaderManager.getInstance().getClassLoader("");
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    @Override
    public String getProtocol() {
        return "tars";
    }
}

