/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client;

import com.qq.tars.common.util.Config;
import com.qq.tars.common.util.Constants;
import com.qq.tars.common.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;

public class CommunicatorConfig {
    private String locator = "";
    private int syncInvokeTimeout = 3000;
    private int asyncInvokeTimeout = 3000;
    private int refreshEndpointInterval = 60000;
    private int reportInterval = 60000;
    private String stat = "tars.tarsstat.StatObj";
    private String property = null;
    private int sampleRate = 0;
    private int maxSampleCount = 0;
    private int sendThread = 1;
    private int recvThread = 1;
    private int asyncThread = 1;
    private String moduleName = "tars-client";
    private boolean enableSet = false;
    private String setDivision = null;
    private String setName;
    private String setArea;
    private String setID;
    private int connections = 4;
    private int connectTimeout = 3000;
    private int corePoolSize = Constants.default_core_pool_size;
    private int maxPoolSize = Constants.default_max_pool_size;
    private int keepAliveTime = 120;
    private int queueSize = 20000;
    private String charsetName = "UTF-8";
    private String logPath;
    private String logLevel = "INFO";
    private String dataPath;

    public static CommunicatorConfig load(String confFile) throws FileNotFoundException, IOException {
        CommunicatorConfig cfg = new CommunicatorConfig();
        cfg.load(Config.parseFile(confFile));
        return cfg;
    }

    public static CommunicatorConfig getDefault() {
        return new CommunicatorConfig();
    }

    public CommunicatorConfig load(Config conf) {
        this.locator = conf.get("/tars/application/client<locator>");
        this.logPath = conf.get("/tars/application/client<logpath>", null);
        this.logLevel = conf.get("/tars/application/client<loglevel>", "INFO");
        this.dataPath = conf.get("/tars/application/client<cdatapath>", null);
        this.syncInvokeTimeout = conf.getInt("/tars/application/client<sync-invoke-timeout>", 3000);
        this.asyncInvokeTimeout = conf.getInt("/tars/application/client<async-invoke-timeout>", 3000);
        this.refreshEndpointInterval = conf.getInt("/tars/application/client<refresh-endpoint-interval>", 60000);
        this.stat = conf.get("/tars/application/client<stat>");
        this.property = conf.get("/tars/application/client<property>");
        this.reportInterval = conf.getInt("/tars/application/client<report-interval>", 60000);
        this.sampleRate = conf.getInt("/tars/application/client<sample-rate>", 1000);
        this.maxSampleCount = conf.getInt("/tars/application/client<max-sample-count>", 100);
        this.sendThread = conf.getInt("/tars/application/client<sendthread>", 1);
        this.recvThread = conf.getInt("/tars/application/client<recvthread>", 1);
        this.asyncThread = conf.getInt("/tars/application/client<asyncthread>", 1);
        this.moduleName = conf.get("/tars/application/client<modulename>", "tars-client");
        String enableSetStr = conf.get("/tars/application<enableset>");
        this.setDivision = conf.get("/tars/application<setdivision>");
        if ("Y".equalsIgnoreCase(enableSetStr)) {
            this.enableSet = true;
        } else {
            this.enableSet = false;
            this.setDivision = null;
        }
        if (this.enableSet && this.setDivision != null) {
            this.setSetDivision(this.setDivision);
        }
        this.connections = conf.getInt("/tars/application/client<connections>", 4);
        this.connectTimeout = conf.getInt("/tars/application/client<connect-timeout>", 3000);
        this.corePoolSize = conf.getInt("/tars/application/client<corepoolsize>", Constants.default_core_pool_size);
        this.maxPoolSize = conf.getInt("/tars/application/client<maxpoolsize>", Constants.default_max_pool_size);
        this.keepAliveTime = conf.getInt("/tars/application/client<keepalivetime>", 120);
        this.queueSize = conf.getInt("/tars/application/client<queuesize>", 20000);
        this.charsetName = conf.get("/tars/application/client<charsetname>", "UTF-8");
        return this;
    }

    public String getLocator() {
        return this.locator;
    }

    public CommunicatorConfig setLocator(String locator) {
        this.locator = locator;
        return this;
    }

    public int getSyncInvokeTimeout() {
        return this.syncInvokeTimeout;
    }

    public CommunicatorConfig setSyncInvokeTimeout(int syncInvokeTimeout) {
        this.syncInvokeTimeout = syncInvokeTimeout;
        return this;
    }

    public int getAsyncInvokeTimeout() {
        return this.asyncInvokeTimeout;
    }

    public CommunicatorConfig setAsyncInvokeTimeout(int asyncInvokeTimeout) {
        this.asyncInvokeTimeout = asyncInvokeTimeout;
        return this;
    }

    public int getRefreshEndpointInterval() {
        return this.refreshEndpointInterval;
    }

    public CommunicatorConfig setRefreshEndpointInterval(int refreshEndpointInterval) {
        this.refreshEndpointInterval = refreshEndpointInterval;
        return this;
    }

    public String getStat() {
        return this.stat;
    }

    public CommunicatorConfig setStat(String stat) {
        this.stat = stat;
        return this;
    }

    public String getProperty() {
        return this.property;
    }

    public CommunicatorConfig setProperty(String property) {
        this.property = property;
        return this;
    }

    public int getReportInterval() {
        return this.reportInterval;
    }

    public CommunicatorConfig setReportInterval(int reportInterval) {
        this.reportInterval = reportInterval;
        return this;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public CommunicatorConfig setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
        return this;
    }

    public int getMaxSampleCount() {
        return this.maxSampleCount;
    }

    public CommunicatorConfig setMaxSampleCount(int maxSampleCount) {
        this.maxSampleCount = maxSampleCount;
        return this;
    }

    @Deprecated
    public int getSendThread() {
        return this.sendThread;
    }

    @Deprecated
    public CommunicatorConfig setSendThread(int sendThread) {
        this.sendThread = sendThread;
        return this;
    }

    @Deprecated
    public int getRecvThread() {
        return this.recvThread;
    }

    @Deprecated
    public CommunicatorConfig setRecvThread(int recvThread) {
        this.recvThread = recvThread;
        return this;
    }

    @Deprecated
    public int getAsyncThread() {
        return this.asyncThread;
    }

    @Deprecated
    public CommunicatorConfig setAsyncThread(int asyncThread) {
        this.asyncThread = asyncThread;
        return this;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public CommunicatorConfig setModuleName(String moduleName) {
        this.moduleName = moduleName;
        return this;
    }

    public boolean isEnableSet() {
        return this.enableSet;
    }

    public CommunicatorConfig setEnableSet(boolean enableSet) {
        this.enableSet = enableSet;
        return this;
    }

    public String getSetDivision() {
        return this.setDivision;
    }

    public CommunicatorConfig setSetDivision(String setDivision) {
        this.setDivision = setDivision;
        if (StringUtils.isNotEmpty(setDivision)) {
            String[] tmp = StringUtils.split(setDivision, ".");
            if (tmp != null && tmp.length == 3) {
                this.setName = tmp[0];
                this.setArea = tmp[1];
                this.setID = tmp[2];
                this.enableSet = true;
            } else {
                this.setName = "";
                this.setArea = "";
                this.setID = "";
                this.enableSet = false;
            }
        }
        return this;
    }

    public String getSetName() {
        return this.setName;
    }

    public String getSetArea() {
        return this.setArea;
    }

    public String getSetID() {
        return this.setID;
    }

    public int getConnections() {
        return this.connections;
    }

    public CommunicatorConfig setConnections(int connections) {
        this.connections = connections;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public CommunicatorConfig setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public CommunicatorConfig setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
        return this;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public CommunicatorConfig setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public CommunicatorConfig setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        return this;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public CommunicatorConfig setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public CommunicatorConfig setLogPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public CommunicatorConfig setLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public CommunicatorConfig setDataPath(String dataPath) {
        this.dataPath = dataPath;
        return this;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public CommunicatorConfig setCharsetName(String charsetName) {
        this.charsetName = charsetName;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.locator == null ? 0 : this.locator.hashCode());
        result = 31 * result + (this.moduleName == null ? 0 : this.moduleName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommunicatorConfig other = (CommunicatorConfig)obj;
        if (!Objects.equals(this.locator, other.locator)) {
            return false;
        }
        return Objects.equals(this.moduleName, other.moduleName);
    }

    public String toString() {
        return "CommunicatorConfig{locator='" + this.locator + '\'' + ", syncInvokeTimeout=" + this.syncInvokeTimeout + ", asyncInvokeTimeout=" + this.asyncInvokeTimeout + ", refreshEndpointInterval=" + this.refreshEndpointInterval + ", reportInterval=" + this.reportInterval + ", stat='" + this.stat + '\'' + ", property='" + this.property + '\'' + ", sampleRate=" + this.sampleRate + ", maxSampleCount=" + this.maxSampleCount + ", sendThread=" + this.sendThread + ", recvThread=" + this.recvThread + ", asyncThread=" + this.asyncThread + ", moduleName='" + this.moduleName + '\'' + ", enableSet=" + this.enableSet + ", setDivision='" + this.setDivision + '\'' + ", setName='" + this.setName + '\'' + ", setArea='" + this.setArea + '\'' + ", setID='" + this.setID + '\'' + ", connections=" + this.connections + ", connectTimeout=" + this.connectTimeout + ", corePoolSize=" + this.corePoolSize + ", maxPoolSize=" + this.maxPoolSize + ", keepAliveTime=" + this.keepAliveTime + ", queueSize=" + this.queueSize + ", charsetName='" + this.charsetName + '\'' + ", logPath='" + this.logPath + '\'' + ", logLevel='" + this.logLevel + '\'' + ", dataPath='" + this.dataPath + '\'' + '}';
    }
}

