/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.metrics.prometheus;

import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.ClientEndInvokeEvent;
import com.alipay.sofa.rpc.event.ConsumerSubEvent;
import com.alipay.sofa.rpc.event.Event;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ProviderPubEvent;
import com.alipay.sofa.rpc.event.ServerSendEvent;
import com.alipay.sofa.rpc.event.ServerStartedEvent;
import com.alipay.sofa.rpc.event.ServerStoppedEvent;
import com.alipay.sofa.rpc.event.Subscriber;
import com.alipay.sofa.rpc.metrics.prometheus.MetricsBuilder;
import io.prometheus.client.Collector;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;

public class SofaRpcMetricsCollector
extends Collector
implements AutoCloseable {
    private static final String[] INVOKE_LABEL_NAMES = new String[]{"app", "service", "method", "protocol", "invoke_type", "caller_app"};
    private String[] commonLabelNames;
    private String[] commonLabelValues;
    private PrometheusSubscriber subscriber;
    private Histogram clientTotal;
    private Histogram clientFail;
    private Histogram serverTotal;
    private Histogram serverFail;
    private Histogram requestSize;
    private Histogram responseSize;
    private Counter providerCounter;
    private Counter consumerCounter;
    private Gauge threadPoolConfigCore;
    private Gauge threadPoolConfigMax;
    private Gauge threadPoolConfigQueue;
    private Gauge threadPoolActive;
    private Gauge threadPoolIdle;
    private Gauge threadPoolQueue;
    private final AtomicReference<ServerConfig> serverConfigReference = new AtomicReference();
    private final AtomicReference<ThreadPoolExecutor> executorReference = new AtomicReference();

    public SofaRpcMetricsCollector() {
        this(Collections.emptyMap(), MetricsBuilder.defaultOf());
    }

    public SofaRpcMetricsCollector(Map<String, String> commonLabels) {
        this(commonLabels, MetricsBuilder.defaultOf());
    }

    public SofaRpcMetricsCollector(MetricsBuilder metricsBuilder) {
        this(Collections.emptyMap(), metricsBuilder);
    }

    public SofaRpcMetricsCollector(Map<String, String> commonLabels, MetricsBuilder metricsBuilder) {
        String[] labelNames;
        this.commonLabelNames = commonLabels.keySet().toArray(new String[0]);
        this.commonLabelValues = commonLabels.values().toArray(new String[0]);
        this.subscriber = new PrometheusSubscriber();
        int clength = this.commonLabelNames.length;
        if (clength == 0) {
            labelNames = INVOKE_LABEL_NAMES;
        } else {
            int ilength = INVOKE_LABEL_NAMES.length;
            labelNames = new String[clength + ilength];
            System.arraycopy(this.commonLabelNames, 0, labelNames, 0, clength);
            System.arraycopy(INVOKE_LABEL_NAMES, 0, labelNames, clength, ilength);
        }
        this.clientTotal = metricsBuilder.buildClientTotal(labelNames);
        this.clientFail = metricsBuilder.buildClientFail(labelNames);
        this.serverTotal = metricsBuilder.buildServerTotal(labelNames);
        this.serverFail = metricsBuilder.buildServerFail(labelNames);
        this.requestSize = metricsBuilder.buildRequestSize(labelNames);
        this.responseSize = metricsBuilder.buildResponseSize(labelNames);
        this.providerCounter = metricsBuilder.buildProviderCounter(this.commonLabelNames);
        this.consumerCounter = metricsBuilder.buildConsumerCounter(this.commonLabelNames);
        this.threadPoolConfigCore = metricsBuilder.buildThreadPoolConfigCore(this.commonLabelNames);
        this.threadPoolConfigMax = metricsBuilder.buildThreadPoolConfigMax(this.commonLabelNames);
        this.threadPoolConfigQueue = metricsBuilder.buildThreadPoolConfigQueue(this.commonLabelNames);
        this.threadPoolActive = metricsBuilder.buildThreadPoolActive(this.commonLabelNames);
        this.threadPoolIdle = metricsBuilder.buildThreadPoolIdle(this.commonLabelNames);
        this.threadPoolQueue = metricsBuilder.buildThreadPoolQueue(this.commonLabelNames);
        this.registerSubscriber();
    }

    private void registerSubscriber() {
        EventBus.register(ClientEndInvokeEvent.class, this.subscriber);
        EventBus.register(ServerSendEvent.class, this.subscriber);
        EventBus.register(ServerStartedEvent.class, this.subscriber);
        EventBus.register(ServerStoppedEvent.class, this.subscriber);
        EventBus.register(ProviderPubEvent.class, this.subscriber);
        EventBus.register(ConsumerSubEvent.class, this.subscriber);
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> result = new ArrayList<Collector.MetricFamilySamples>();
        result.addAll(this.clientTotal.collect());
        result.addAll(this.clientFail.collect());
        result.addAll(this.serverTotal.collect());
        result.addAll(this.serverFail.collect());
        result.addAll(this.requestSize.collect());
        result.addAll(this.responseSize.collect());
        result.addAll(this.providerCounter.collect());
        result.addAll(this.consumerCounter.collect());
        ServerConfig serverConfig = this.serverConfigReference.get();
        ThreadPoolExecutor threadPoolExecutor = this.executorReference.get();
        if (serverConfig != null) {
            ((Gauge.Child)this.threadPoolConfigCore.labels(this.commonLabelValues)).set((double)serverConfig.getCoreThreads());
            result.addAll(this.threadPoolConfigCore.collect());
            ((Gauge.Child)this.threadPoolConfigMax.labels(this.commonLabelValues)).set((double)serverConfig.getMaxThreads());
            result.addAll(this.threadPoolConfigMax.collect());
            ((Gauge.Child)this.threadPoolConfigQueue.labels(this.commonLabelValues)).set((double)serverConfig.getQueues());
            result.addAll(this.threadPoolConfigQueue.collect());
        }
        if (threadPoolExecutor != null) {
            ((Gauge.Child)this.threadPoolActive.labels(this.commonLabelValues)).set((double)threadPoolExecutor.getActiveCount());
            result.addAll(this.threadPoolActive.collect());
            ((Gauge.Child)this.threadPoolIdle.labels(this.commonLabelValues)).set((double)(threadPoolExecutor.getPoolSize() - threadPoolExecutor.getActiveCount()));
            result.addAll(this.threadPoolIdle.collect());
            ((Gauge.Child)this.threadPoolQueue.labels(this.commonLabelValues)).set((double)threadPoolExecutor.getQueue().size());
            result.addAll(this.threadPoolQueue.collect());
        }
        return result;
    }

    @Override
    public void close() throws Exception {
        EventBus.unRegister(ClientEndInvokeEvent.class, this.subscriber);
        EventBus.unRegister(ServerSendEvent.class, this.subscriber);
        EventBus.unRegister(ServerStartedEvent.class, this.subscriber);
        EventBus.unRegister(ServerStoppedEvent.class, this.subscriber);
        EventBus.unRegister(ProviderPubEvent.class, this.subscriber);
        EventBus.unRegister(ConsumerSubEvent.class, this.subscriber);
    }

    private static Long getLongAvoidNull(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return Long.parseLong(object.toString());
        }
        return (Long)object;
    }

    private static String getStringAvoidNull(Object object) {
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    private static class InvokeMeta {
        private final SofaRequest request;
        private final SofaResponse response;
        private final long elapsed;

        private InvokeMeta(SofaRequest request, SofaResponse response, long elapsed) {
            this.request = request;
            this.response = response;
            this.elapsed = elapsed;
        }

        public String app() {
            return Optional.ofNullable(this.request.getTargetAppName()).orElse("");
        }

        public String callerApp() {
            return Optional.ofNullable(SofaRpcMetricsCollector.getStringAvoidNull(this.request.getRequestProp("app"))).orElse("");
        }

        public String service() {
            return Optional.ofNullable(this.request.getTargetServiceUniqueName()).orElse("");
        }

        public String method() {
            return Optional.ofNullable(this.request.getMethodName()).orElse("");
        }

        public String protocol() {
            return Optional.ofNullable(SofaRpcMetricsCollector.getStringAvoidNull(this.request.getRequestProp("protocol"))).orElse("");
        }

        public String invokeType() {
            return Optional.ofNullable(this.request.getInvokeType()).orElse("");
        }

        public long elapsed() {
            return this.elapsed;
        }

        public boolean success() {
            return this.response != null && !this.response.isError() && this.response.getErrorMsg() == null && !(this.response.getAppResponse() instanceof Throwable);
        }

        public String[] labelValues(String[] commonLabelValues) {
            String[] labelValues;
            String[] invokeLabelValues = new String[]{this.app(), this.service(), this.method(), this.protocol(), this.invokeType(), this.callerApp()};
            int clength = commonLabelValues.length;
            if (clength == 0) {
                labelValues = invokeLabelValues;
            } else {
                int ilength = invokeLabelValues.length;
                labelValues = new String[clength + ilength];
                System.arraycopy(commonLabelValues, 0, labelValues, 0, clength);
                System.arraycopy(invokeLabelValues, 0, labelValues, clength, ilength);
            }
            return labelValues;
        }
    }

    private class PrometheusSubscriber
    extends Subscriber {
        private PrometheusSubscriber() {
        }

        @Override
        public void onEvent(Event event) {
            if (event instanceof ClientEndInvokeEvent) {
                this.onEvent((ClientEndInvokeEvent)event);
            } else if (event instanceof ServerSendEvent) {
                this.onEvent((ServerSendEvent)event);
            } else if (event instanceof ServerStartedEvent) {
                this.onEvent((ServerStartedEvent)event);
            } else if (event instanceof ServerStoppedEvent) {
                this.onEvent((ServerStoppedEvent)event);
            } else if (event instanceof ProviderPubEvent) {
                this.onEvent((ProviderPubEvent)event);
            } else if (event instanceof ConsumerSubEvent) {
                this.onEvent((ConsumerSubEvent)event);
            } else {
                throw new IllegalArgumentException("unexpected event: " + event);
            }
        }

        private void onEvent(ClientEndInvokeEvent event) {
            InvokeMeta meta = new InvokeMeta(event.getRequest(), event.getResponse(), SofaRpcMetricsCollector.getLongAvoidNull(RpcInternalContext.getContext().getAttachment("_client_elapse")));
            long elapsed = meta.elapsed();
            String[] labelValues = meta.labelValues(SofaRpcMetricsCollector.this.commonLabelValues);
            ((Histogram.Child)SofaRpcMetricsCollector.this.clientTotal.labels(labelValues)).observe((double)elapsed);
            if (!meta.success()) {
                ((Histogram.Child)SofaRpcMetricsCollector.this.clientFail.labels(labelValues)).observe((double)elapsed);
            }
            RpcInternalContext context = RpcInternalContext.getContext();
            ((Histogram.Child)SofaRpcMetricsCollector.this.requestSize.labels(labelValues)).observe((double)SofaRpcMetricsCollector.getLongAvoidNull(context.getAttachment("_req_size")).longValue());
            ((Histogram.Child)SofaRpcMetricsCollector.this.responseSize.labels(labelValues)).observe((double)SofaRpcMetricsCollector.getLongAvoidNull(context.getAttachment("_resp_size")).longValue());
        }

        private void onEvent(ServerSendEvent event) {
            InvokeMeta meta = new InvokeMeta(event.getRequest(), event.getResponse(), SofaRpcMetricsCollector.getLongAvoidNull(RpcInternalContext.getContext().getAttachment("_impl_elapse")));
            long elapsed = meta.elapsed();
            String[] labelValues = meta.labelValues(SofaRpcMetricsCollector.this.commonLabelValues);
            ((Histogram.Child)SofaRpcMetricsCollector.this.serverTotal.labels(labelValues)).observe((double)elapsed);
            if (!meta.success()) {
                ((Histogram.Child)SofaRpcMetricsCollector.this.serverFail.labels(labelValues)).observe((double)elapsed);
            }
        }

        private void onEvent(ServerStartedEvent event) {
            SofaRpcMetricsCollector.this.serverConfigReference.set(event.getServerConfig());
            SofaRpcMetricsCollector.this.executorReference.set(event.getThreadPoolExecutor());
        }

        private void onEvent(ServerStoppedEvent event) {
            SofaRpcMetricsCollector.this.serverConfigReference.set(null);
            SofaRpcMetricsCollector.this.executorReference.set(null);
        }

        private void onEvent(ProviderPubEvent event) {
            ((Counter.Child)SofaRpcMetricsCollector.this.providerCounter.labels(SofaRpcMetricsCollector.this.commonLabelValues)).inc();
        }

        private void onEvent(ConsumerSubEvent event) {
            ((Counter.Child)SofaRpcMetricsCollector.this.consumerCounter.labels(SofaRpcMetricsCollector.this.commonLabelValues)).inc();
        }
    }
}

